package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataSourceErrorMessage(
    errorDetail: Optional[String] = Optional.Absent,
    errorType: zio.aws.datazone.model.DataSourceErrorType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DataSourceErrorMessage = {
    import DataSourceErrorMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DataSourceErrorMessage
      .builder()
      .optionallyWith(errorDetail.map(value => value: java.lang.String))(
        _.errorDetail
      )
      .errorType(errorType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly =
    zio.aws.datazone.model.DataSourceErrorMessage.wrap(buildAwsValue())
}
object DataSourceErrorMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DataSourceErrorMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DataSourceErrorMessage =
      zio.aws.datazone.model
        .DataSourceErrorMessage(errorDetail.map(value => value), errorType)
    def errorDetail: Optional[String]
    def errorType: zio.aws.datazone.model.DataSourceErrorType
    def getErrorDetail: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorDetail", errorDetail)
    def getErrorType
        : ZIO[Any, Nothing, zio.aws.datazone.model.DataSourceErrorType] =
      ZIO.succeed(errorType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DataSourceErrorMessage
  ) extends zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly {
    override val errorDetail: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorDetail())
      .map(value => value: String)
    override val errorType: zio.aws.datazone.model.DataSourceErrorType =
      zio.aws.datazone.model.DataSourceErrorType.wrap(impl.errorType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DataSourceErrorMessage
  ): zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly = new Wrapper(impl)
}
