package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataSourceConfigurationOutput(
    glueRunConfiguration: Optional[
      zio.aws.datazone.model.GlueRunConfigurationOutput
    ] = Optional.Absent,
    redshiftRunConfiguration: Optional[
      zio.aws.datazone.model.RedshiftRunConfigurationOutput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DataSourceConfigurationOutput = {
    import DataSourceConfigurationOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DataSourceConfigurationOutput
      .builder()
      .optionallyWith(glueRunConfiguration.map(value => value.buildAwsValue()))(
        _.glueRunConfiguration
      )
      .optionallyWith(
        redshiftRunConfiguration.map(value => value.buildAwsValue())
      )(_.redshiftRunConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.DataSourceConfigurationOutput.ReadOnly =
    zio.aws.datazone.model.DataSourceConfigurationOutput.wrap(buildAwsValue())
}
object DataSourceConfigurationOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DataSourceConfigurationOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DataSourceConfigurationOutput =
      zio.aws.datazone.model.DataSourceConfigurationOutput(
        glueRunConfiguration.map(value => value.asEditable),
        redshiftRunConfiguration.map(value => value.asEditable)
      )
    def glueRunConfiguration
        : Optional[zio.aws.datazone.model.GlueRunConfigurationOutput.ReadOnly]
    def redshiftRunConfiguration: Optional[
      zio.aws.datazone.model.RedshiftRunConfigurationOutput.ReadOnly
    ]
    def getGlueRunConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.GlueRunConfigurationOutput.ReadOnly
    ] = AwsError.unwrapOptionField("glueRunConfiguration", glueRunConfiguration)
    def getRedshiftRunConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.RedshiftRunConfigurationOutput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "redshiftRunConfiguration",
      redshiftRunConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DataSourceConfigurationOutput
  ) extends zio.aws.datazone.model.DataSourceConfigurationOutput.ReadOnly {
    override val glueRunConfiguration
        : Optional[zio.aws.datazone.model.GlueRunConfigurationOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glueRunConfiguration())
        .map(value =>
          zio.aws.datazone.model.GlueRunConfigurationOutput.wrap(value)
        )
    override val redshiftRunConfiguration: Optional[
      zio.aws.datazone.model.RedshiftRunConfigurationOutput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.redshiftRunConfiguration())
      .map(value =>
        zio.aws.datazone.model.RedshiftRunConfigurationOutput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DataSourceConfigurationOutput
  ): zio.aws.datazone.model.DataSourceConfigurationOutput.ReadOnly =
    new Wrapper(impl)
}
