package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{UserProfileId, DomainId}
import scala.jdk.CollectionConverters.*
final case class CreateUserProfileResponse(
    details: Optional[zio.aws.datazone.model.UserProfileDetails] =
      Optional.Absent,
    domainId: Optional[DomainId] = Optional.Absent,
    id: Optional[UserProfileId] = Optional.Absent,
    status: Optional[zio.aws.datazone.model.UserProfileStatus] =
      Optional.Absent,
    `type`: Optional[zio.aws.datazone.model.UserProfileType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateUserProfileResponse = {
    import CreateUserProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateUserProfileResponse
      .builder()
      .optionallyWith(details.map(value => value.buildAwsValue()))(_.details)
      .optionallyWith(
        domainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        id.map(value => UserProfileId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateUserProfileResponse.ReadOnly =
    zio.aws.datazone.model.CreateUserProfileResponse.wrap(buildAwsValue())
}
object CreateUserProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateUserProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateUserProfileResponse =
      zio.aws.datazone.model.CreateUserProfileResponse(
        details.map(value => value.asEditable),
        domainId.map(value => value),
        id.map(value => value),
        status.map(value => value),
        `type`.map(value => value)
      )
    def details: Optional[zio.aws.datazone.model.UserProfileDetails.ReadOnly]
    def domainId: Optional[DomainId]
    def id: Optional[UserProfileId]
    def status: Optional[zio.aws.datazone.model.UserProfileStatus]
    def `type`: Optional[zio.aws.datazone.model.UserProfileType]
    def getDetails: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.UserProfileDetails.ReadOnly
    ] = AwsError.unwrapOptionField("details", details)
    def getDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getId: ZIO[Any, AwsError, UserProfileId] =
      AwsError.unwrapOptionField("id", id)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datazone.model.UserProfileStatus] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, zio.aws.datazone.model.UserProfileType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateUserProfileResponse
  ) extends zio.aws.datazone.model.CreateUserProfileResponse.ReadOnly {
    override val details
        : Optional[zio.aws.datazone.model.UserProfileDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.details())
        .map(value => zio.aws.datazone.model.UserProfileDetails.wrap(value))
    override val domainId: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainId())
      .map(value => zio.aws.datazone.model.primitives.DomainId(value))
    override val id: Optional[UserProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.datazone.model.primitives.UserProfileId(value))
    override val status: Optional[zio.aws.datazone.model.UserProfileStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.UserProfileStatus.wrap(value))
    override val `type`: Optional[zio.aws.datazone.model.UserProfileType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.datazone.model.UserProfileType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateUserProfileResponse
  ): zio.aws.datazone.model.CreateUserProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
