package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{Revision, ListingId}
import scala.jdk.CollectionConverters.*
final case class CreateListingChangeSetResponse(
    listingId: ListingId,
    listingRevision: Revision,
    status: zio.aws.datazone.model.ListingStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateListingChangeSetResponse = {
    import CreateListingChangeSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateListingChangeSetResponse
      .builder()
      .listingId(ListingId.unwrap(listingId): java.lang.String)
      .listingRevision(Revision.unwrap(listingRevision): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.CreateListingChangeSetResponse.ReadOnly =
    zio.aws.datazone.model.CreateListingChangeSetResponse.wrap(buildAwsValue())
}
object CreateListingChangeSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateListingChangeSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateListingChangeSetResponse =
      zio.aws.datazone.model
        .CreateListingChangeSetResponse(listingId, listingRevision, status)
    def listingId: ListingId
    def listingRevision: Revision
    def status: zio.aws.datazone.model.ListingStatus
    def getListingId: ZIO[Any, Nothing, ListingId] = ZIO.succeed(listingId)
    def getListingRevision: ZIO[Any, Nothing, Revision] =
      ZIO.succeed(listingRevision)
    def getStatus: ZIO[Any, Nothing, zio.aws.datazone.model.ListingStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateListingChangeSetResponse
  ) extends zio.aws.datazone.model.CreateListingChangeSetResponse.ReadOnly {
    override val listingId: ListingId =
      zio.aws.datazone.model.primitives.ListingId(impl.listingId())
    override val listingRevision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.listingRevision())
    override val status: zio.aws.datazone.model.ListingStatus =
      zio.aws.datazone.model.ListingStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateListingChangeSetResponse
  ): zio.aws.datazone.model.CreateListingChangeSetResponse.ReadOnly =
    new Wrapper(impl)
}
