package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  DataSourceType,
  Name,
  DomainId,
  Description
}
import scala.jdk.CollectionConverters.*
final case class CreateDataSourceRequest(
    assetFormsInput: Optional[Iterable[zio.aws.datazone.model.FormInput]] =
      Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    configuration: Optional[
      zio.aws.datazone.model.DataSourceConfigurationInput
    ] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    domainIdentifier: DomainId,
    enableSetting: Optional[zio.aws.datazone.model.EnableSetting] =
      Optional.Absent,
    environmentIdentifier: String,
    name: Name,
    projectIdentifier: String,
    publishOnImport: Optional[Boolean] = Optional.Absent,
    recommendation: Optional[
      zio.aws.datazone.model.RecommendationConfiguration
    ] = Optional.Absent,
    schedule: Optional[zio.aws.datazone.model.ScheduleConfiguration] =
      Optional.Absent,
    `type`: DataSourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateDataSourceRequest = {
    import CreateDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateDataSourceRequest
      .builder()
      .optionallyWith(
        assetFormsInput.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assetFormsInput)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(enableSetting.map(value => value.unwrap))(_.enableSetting)
      .environmentIdentifier(environmentIdentifier: java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .projectIdentifier(projectIdentifier: java.lang.String)
      .optionallyWith(publishOnImport.map(value => value: java.lang.Boolean))(
        _.publishOnImport
      )
      .optionallyWith(recommendation.map(value => value.buildAwsValue()))(
        _.recommendation
      )
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .`type`(DataSourceType.unwrap(`type`): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateDataSourceRequest.ReadOnly =
    zio.aws.datazone.model.CreateDataSourceRequest.wrap(buildAwsValue())
}
object CreateDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateDataSourceRequest =
      zio.aws.datazone.model.CreateDataSourceRequest(
        assetFormsInput.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value),
        configuration.map(value => value.asEditable),
        description.map(value => value),
        domainIdentifier,
        enableSetting.map(value => value),
        environmentIdentifier,
        name,
        projectIdentifier,
        publishOnImport.map(value => value),
        recommendation.map(value => value.asEditable),
        schedule.map(value => value.asEditable),
        `type`
      )
    def assetFormsInput
        : Optional[List[zio.aws.datazone.model.FormInput.ReadOnly]]
    def clientToken: Optional[String]
    def configuration
        : Optional[zio.aws.datazone.model.DataSourceConfigurationInput.ReadOnly]
    def description: Optional[Description]
    def domainIdentifier: DomainId
    def enableSetting: Optional[zio.aws.datazone.model.EnableSetting]
    def environmentIdentifier: String
    def name: Name
    def projectIdentifier: String
    def publishOnImport: Optional[Boolean]
    def recommendation
        : Optional[zio.aws.datazone.model.RecommendationConfiguration.ReadOnly]
    def schedule
        : Optional[zio.aws.datazone.model.ScheduleConfiguration.ReadOnly]
    def `type`: DataSourceType
    def getAssetFormsInput
        : ZIO[Any, AwsError, List[zio.aws.datazone.model.FormInput.ReadOnly]] =
      AwsError.unwrapOptionField("assetFormsInput", assetFormsInput)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.DataSourceConfigurationInput.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getEnableSetting
        : ZIO[Any, AwsError, zio.aws.datazone.model.EnableSetting] =
      AwsError.unwrapOptionField("enableSetting", enableSetting)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentIdentifier)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getProjectIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(projectIdentifier)
    def getPublishOnImport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publishOnImport", publishOnImport)
    def getRecommendation: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.RecommendationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("recommendation", recommendation)
    def getSchedule: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.ScheduleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("schedule", schedule)
    def getType: ZIO[Any, Nothing, DataSourceType] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateDataSourceRequest
  ) extends zio.aws.datazone.model.CreateDataSourceRequest.ReadOnly {
    override val assetFormsInput
        : Optional[List[zio.aws.datazone.model.FormInput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetFormsInput())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.FormInput.wrap(item)
          }.toList
        )
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val configuration: Optional[
      zio.aws.datazone.model.DataSourceConfigurationInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configuration())
      .map(value =>
        zio.aws.datazone.model.DataSourceConfigurationInput.wrap(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val enableSetting: Optional[zio.aws.datazone.model.EnableSetting] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableSetting())
        .map(value => zio.aws.datazone.model.EnableSetting.wrap(value))
    override val environmentIdentifier: String =
      impl.environmentIdentifier(): String
    override val name: Name =
      zio.aws.datazone.model.primitives.Name(impl.name())
    override val projectIdentifier: String = impl.projectIdentifier(): String
    override val publishOnImport: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publishOnImport())
      .map(value => value: Boolean)
    override val recommendation: Optional[
      zio.aws.datazone.model.RecommendationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendation())
      .map(value =>
        zio.aws.datazone.model.RecommendationConfiguration.wrap(value)
      )
    override val schedule
        : Optional[zio.aws.datazone.model.ScheduleConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.datazone.model.ScheduleConfiguration.wrap(value))
    override val `type`: DataSourceType =
      zio.aws.datazone.model.primitives.DataSourceType(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateDataSourceRequest
  ): zio.aws.datazone.model.CreateDataSourceRequest.ReadOnly = new Wrapper(impl)
}
