package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait ChangeAction {
  def unwrap: software.amazon.awssdk.services.datazone.model.ChangeAction
}
object ChangeAction {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.ChangeAction
  ): zio.aws.datazone.model.ChangeAction = value match {
    case software.amazon.awssdk.services.datazone.model.ChangeAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.ChangeAction.PUBLISH =>
      val r = PUBLISH
      r
    case software.amazon.awssdk.services.datazone.model.ChangeAction.UNPUBLISH =>
      val r = UNPUBLISH
      r
  }
  case object unknownToSdkVersion extends zio.aws.datazone.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.ChangeAction =
      software.amazon.awssdk.services.datazone.model.ChangeAction.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLISH extends zio.aws.datazone.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.ChangeAction =
      software.amazon.awssdk.services.datazone.model.ChangeAction.PUBLISH
  }
  case object UNPUBLISH extends zio.aws.datazone.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.ChangeAction =
      software.amazon.awssdk.services.datazone.model.ChangeAction.UNPUBLISH
  }
}
