package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BusinessNameGenerationConfiguration(
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.BusinessNameGenerationConfiguration = {
    import BusinessNameGenerationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.BusinessNameGenerationConfiguration
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.BusinessNameGenerationConfiguration.ReadOnly =
    zio.aws.datazone.model.BusinessNameGenerationConfiguration
      .wrap(buildAwsValue())
}
object BusinessNameGenerationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.BusinessNameGenerationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.BusinessNameGenerationConfiguration =
      zio.aws.datazone.model
        .BusinessNameGenerationConfiguration(enabled.map(value => value))
    def enabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.BusinessNameGenerationConfiguration
  ) extends zio.aws.datazone.model.BusinessNameGenerationConfiguration.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.BusinessNameGenerationConfiguration
  ): zio.aws.datazone.model.BusinessNameGenerationConfiguration.ReadOnly =
    new Wrapper(impl)
}
