package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  AssetId,
  CreatedAt,
  DomainId,
  Revision,
  CreatedBy
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AssetRevision(
    createdAt: Optional[CreatedAt] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    domainId: Optional[DomainId] = Optional.Absent,
    id: Optional[AssetId] = Optional.Absent,
    revision: Optional[Revision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.AssetRevision = {
    import AssetRevision.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.AssetRevision
      .builder()
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        domainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(id.map(value => AssetId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        revision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.revision)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.AssetRevision.ReadOnly =
    zio.aws.datazone.model.AssetRevision.wrap(buildAwsValue())
}
object AssetRevision {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.AssetRevision
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.AssetRevision =
      zio.aws.datazone.model.AssetRevision(
        createdAt.map(value => value),
        createdBy.map(value => value),
        domainId.map(value => value),
        id.map(value => value),
        revision.map(value => value)
      )
    def createdAt: Optional[CreatedAt]
    def createdBy: Optional[CreatedBy]
    def domainId: Optional[DomainId]
    def id: Optional[AssetId]
    def revision: Optional[Revision]
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getId: ZIO[Any, AwsError, AssetId] =
      AwsError.unwrapOptionField("id", id)
    def getRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("revision", revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.AssetRevision
  ) extends zio.aws.datazone.model.AssetRevision.ReadOnly {
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.datazone.model.primitives.CreatedAt(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.datazone.model.primitives.CreatedBy(value))
    override val domainId: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainId())
      .map(value => zio.aws.datazone.model.primitives.DomainId(value))
    override val id: Optional[AssetId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.datazone.model.primitives.AssetId(value))
    override val revision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.AssetRevision
  ): zio.aws.datazone.model.AssetRevision.ReadOnly = new Wrapper(impl)
}
