package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.Forms
import scala.jdk.CollectionConverters.*
final case class AssetListingItemAdditionalAttributes(
    forms: Optional[Forms] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.AssetListingItemAdditionalAttributes = {
    import AssetListingItemAdditionalAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.AssetListingItemAdditionalAttributes
      .builder()
      .optionallyWith(
        forms.map(value => Forms.unwrap(value): java.lang.String)
      )(_.forms)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.AssetListingItemAdditionalAttributes.ReadOnly =
    zio.aws.datazone.model.AssetListingItemAdditionalAttributes
      .wrap(buildAwsValue())
}
object AssetListingItemAdditionalAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.AssetListingItemAdditionalAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datazone.model.AssetListingItemAdditionalAttributes =
      zio.aws.datazone.model
        .AssetListingItemAdditionalAttributes(forms.map(value => value))
    def forms: Optional[Forms]
    def getForms: ZIO[Any, AwsError, Forms] =
      AwsError.unwrapOptionField("forms", forms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.AssetListingItemAdditionalAttributes
  ) extends zio.aws.datazone.model.AssetListingItemAdditionalAttributes.ReadOnly {
    override val forms: Optional[Forms] = zio.aws.core.internal
      .optionalFromNullable(impl.forms())
      .map(value => zio.aws.datazone.model.primitives.Forms(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.AssetListingItemAdditionalAttributes
  ): zio.aws.datazone.model.AssetListingItemAdditionalAttributes.ReadOnly =
    new Wrapper(impl)
}
