package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  SubscriptionRequestId,
  DomainId,
  DecisionComment
}
import scala.jdk.CollectionConverters.*
final case class AcceptSubscriptionRequestRequest(
    decisionComment: Optional[DecisionComment] = Optional.Absent,
    domainIdentifier: DomainId,
    identifier: SubscriptionRequestId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestRequest = {
    import AcceptSubscriptionRequestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestRequest
      .builder()
      .optionallyWith(
        decisionComment.map(value =>
          DecisionComment.unwrap(value): java.lang.String
        )
      )(_.decisionComment)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(SubscriptionRequestId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.AcceptSubscriptionRequestRequest.ReadOnly =
    zio.aws.datazone.model.AcceptSubscriptionRequestRequest
      .wrap(buildAwsValue())
}
object AcceptSubscriptionRequestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.AcceptSubscriptionRequestRequest =
      zio.aws.datazone.model.AcceptSubscriptionRequestRequest(
        decisionComment.map(value => value),
        domainIdentifier,
        identifier
      )
    def decisionComment: Optional[DecisionComment]
    def domainIdentifier: DomainId
    def identifier: SubscriptionRequestId
    def getDecisionComment: ZIO[Any, AwsError, DecisionComment] =
      AwsError.unwrapOptionField("decisionComment", decisionComment)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, SubscriptionRequestId] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestRequest
  ) extends zio.aws.datazone.model.AcceptSubscriptionRequestRequest.ReadOnly {
    override val decisionComment: Optional[DecisionComment] =
      zio.aws.core.internal
        .optionalFromNullable(impl.decisionComment())
        .map(value => zio.aws.datazone.model.primitives.DecisionComment(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: SubscriptionRequestId =
      zio.aws.datazone.model.primitives.SubscriptionRequestId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestRequest
  ): zio.aws.datazone.model.AcceptSubscriptionRequestRequest.ReadOnly =
    new Wrapper(impl)
}
