package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  Revision,
  AssetIdentifier,
  DomainId,
  ClientToken
}
import scala.jdk.CollectionConverters.*
final case class AcceptPredictionsRequest(
    acceptChoices: Optional[Iterable[zio.aws.datazone.model.AcceptChoice]] =
      Optional.Absent,
    acceptRule: Optional[zio.aws.datazone.model.AcceptRule] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    domainIdentifier: DomainId,
    identifier: AssetIdentifier,
    revision: Optional[Revision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.AcceptPredictionsRequest = {
    import AcceptPredictionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.AcceptPredictionsRequest
      .builder()
      .optionallyWith(
        acceptChoices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.acceptChoices)
      .optionallyWith(acceptRule.map(value => value.buildAwsValue()))(
        _.acceptRule
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(AssetIdentifier.unwrap(identifier): java.lang.String)
      .optionallyWith(
        revision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.revision)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.AcceptPredictionsRequest.ReadOnly =
    zio.aws.datazone.model.AcceptPredictionsRequest.wrap(buildAwsValue())
}
object AcceptPredictionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.AcceptPredictionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.AcceptPredictionsRequest =
      zio.aws.datazone.model.AcceptPredictionsRequest(
        acceptChoices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        acceptRule.map(value => value.asEditable),
        clientToken.map(value => value),
        domainIdentifier,
        identifier,
        revision.map(value => value)
      )
    def acceptChoices
        : Optional[List[zio.aws.datazone.model.AcceptChoice.ReadOnly]]
    def acceptRule: Optional[zio.aws.datazone.model.AcceptRule.ReadOnly]
    def clientToken: Optional[ClientToken]
    def domainIdentifier: DomainId
    def identifier: AssetIdentifier
    def revision: Optional[Revision]
    def getAcceptChoices: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.AcceptChoice.ReadOnly
    ]] = AwsError.unwrapOptionField("acceptChoices", acceptChoices)
    def getAcceptRule
        : ZIO[Any, AwsError, zio.aws.datazone.model.AcceptRule.ReadOnly] =
      AwsError.unwrapOptionField("acceptRule", acceptRule)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, AssetIdentifier] =
      ZIO.succeed(identifier)
    def getRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("revision", revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.AcceptPredictionsRequest
  ) extends zio.aws.datazone.model.AcceptPredictionsRequest.ReadOnly {
    override val acceptChoices
        : Optional[List[zio.aws.datazone.model.AcceptChoice.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptChoices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.AcceptChoice.wrap(item)
          }.toList
        )
    override val acceptRule
        : Optional[zio.aws.datazone.model.AcceptRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptRule())
        .map(value => zio.aws.datazone.model.AcceptRule.wrap(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.datazone.model.primitives.ClientToken(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: AssetIdentifier =
      zio.aws.datazone.model.primitives.AssetIdentifier(impl.identifier())
    override val revision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.AcceptPredictionsRequest
  ): zio.aws.datazone.model.AcceptPredictionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
