package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class AcceptChoice(
    predictionChoice: Optional[Integer] = Optional.Absent,
    predictionTarget: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.AcceptChoice = {
    import AcceptChoice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.AcceptChoice
      .builder()
      .optionallyWith(predictionChoice.map(value => value: java.lang.Integer))(
        _.predictionChoice
      )
      .optionallyWith(predictionTarget.map(value => value: java.lang.String))(
        _.predictionTarget
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.AcceptChoice.ReadOnly =
    zio.aws.datazone.model.AcceptChoice.wrap(buildAwsValue())
}
object AcceptChoice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.AcceptChoice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.AcceptChoice =
      zio.aws.datazone.model.AcceptChoice(
        predictionChoice.map(value => value),
        predictionTarget.map(value => value)
      )
    def predictionChoice: Optional[Integer]
    def predictionTarget: Optional[String]
    def getPredictionChoice: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("predictionChoice", predictionChoice)
    def getPredictionTarget: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("predictionTarget", predictionTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.AcceptChoice
  ) extends zio.aws.datazone.model.AcceptChoice.ReadOnly {
    override val predictionChoice: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.predictionChoice())
      .map(value => value: Integer)
    override val predictionTarget: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.predictionTarget())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.AcceptChoice
  ): zio.aws.datazone.model.AcceptChoice.ReadOnly = new Wrapper(impl)
}
