package zio.aws.datazone
import zio.aws.datazone.model.ListSubscriptionsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.datazone.paginators.{
  ListSubscriptionRequestsPublisher,
  ListNotificationsPublisher,
  SearchListingsPublisher,
  SearchPublisher,
  ListEnvironmentProfilesPublisher,
  ListDataSourceRunsPublisher,
  ListAssetRevisionsPublisher,
  ListEnvironmentsPublisher,
  ListSubscriptionTargetsPublisher,
  ListDomainsPublisher,
  ListProjectMembershipsPublisher,
  ListDataSourceRunActivitiesPublisher,
  ListProjectsPublisher,
  ListSubscriptionGrantsPublisher,
  ListSubscriptionsPublisher,
  SearchTypesPublisher,
  SearchGroupProfilesPublisher,
  ListEnvironmentBlueprintsPublisher,
  SearchUserProfilesPublisher,
  ListDataSourcesPublisher,
  ListEnvironmentBlueprintConfigurationsPublisher
}
import software.amazon.awssdk.services.datazone.{
  DataZoneAsyncClientBuilder,
  DataZoneAsyncClient
}
import zio.aws.datazone.model.{
  DeleteAssetRequest,
  UpdateGroupProfileRequest,
  DeleteFormTypeRequest,
  DeleteListingRequest,
  CreateAssetRevisionRequest,
  GetAssetTypeRequest,
  CreateGroupProfileRequest,
  UpdateGlossaryTermRequest,
  CreateSubscriptionTargetRequest,
  GetEnvironmentRequest,
  GetUserProfileRequest,
  GetProjectRequest,
  GetSubscriptionRequestDetailsRequest,
  ListEnvironmentsRequest,
  UpdateDataSourceRequest,
  CreateProjectRequest,
  GetGroupProfileRequest,
  CreateSubscriptionRequestRequest,
  CreateGlossaryRequest,
  DeleteGlossaryRequest,
  UpdateDomainRequest,
  ListNotificationsRequest,
  UpdateGlossaryRequest,
  AcceptSubscriptionRequestRequest,
  UpdateEnvironmentRequest,
  ListEnvironmentBlueprintConfigurationsRequest,
  CreateSubscriptionGrantRequest,
  CreateListingChangeSetRequest,
  DeleteEnvironmentBlueprintConfigurationRequest,
  CreateFormTypeRequest,
  ListTagsForResourceRequest,
  ListSubscriptionRequestsRequest,
  PutEnvironmentBlueprintConfigurationRequest,
  CreateAssetRequest,
  CreateDataSourceRequest,
  AcceptPredictionsRequest,
  ListDataSourceRunActivitiesRequest,
  UpdateSubscriptionTargetRequest,
  RejectSubscriptionRequestRequest,
  UpdateProjectRequest,
  GetIamPortalLoginUrlRequest,
  GetSubscriptionGrantRequest,
  GetDataSourceRequest,
  SearchRequest,
  CreateGlossaryTermRequest,
  ListEnvironmentProfilesRequest,
  DeleteProjectRequest,
  DeleteDomainRequest,
  ListDataSourceRunsRequest,
  GetEnvironmentBlueprintRequest,
  ListSubscriptionsRequest,
  RevokeSubscriptionRequest,
  ListDataSourcesRequest,
  SearchUserProfilesRequest,
  DeleteProjectMembershipRequest,
  ListSubscriptionGrantsRequest,
  GetEnvironmentBlueprintConfigurationRequest,
  GetEnvironmentProfileRequest,
  DeleteDataSourceRequest,
  DeleteAssetTypeRequest,
  CreateDomainRequest,
  CreateProjectMembershipRequest,
  ListProjectsRequest,
  UntagResourceRequest,
  SearchTypesRequest,
  GetAssetRequest,
  ListProjectMembershipsRequest,
  GetDomainRequest,
  GetDataSourceRunRequest,
  GetSubscriptionRequest,
  UpdateSubscriptionRequestRequest,
  GetGlossaryRequest,
  GetFormTypeRequest,
  SearchGroupProfilesRequest,
  StartDataSourceRunRequest,
  SearchListingsRequest,
  CreateEnvironmentRequest,
  ListSubscriptionTargetsRequest,
  DeleteEnvironmentRequest,
  GetSubscriptionTargetRequest,
  DeleteSubscriptionTargetRequest,
  DeleteGlossaryTermRequest,
  GetGlossaryTermRequest,
  DeleteEnvironmentProfileRequest,
  GetListingRequest,
  CreateEnvironmentProfileRequest,
  RejectPredictionsRequest,
  DeleteSubscriptionGrantRequest,
  ListAssetRevisionsRequest,
  DeleteSubscriptionRequestRequest,
  UpdateEnvironmentProfileRequest,
  UpdateSubscriptionGrantStatusRequest,
  ListEnvironmentBlueprintsRequest,
  ListDomainsRequest,
  CreateUserProfileRequest,
  TagResourceRequest,
  UpdateUserProfileRequest,
  CancelSubscriptionRequest,
  CreateAssetTypeRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.datazone.model.{
  UserProfileSummary,
  CancelSubscriptionResponse,
  GetSubscriptionRequestDetailsResponse,
  SubscriptionTargetSummary,
  GetSubscriptionTargetResponse,
  DeleteEnvironmentBlueprintConfigurationResponse,
  CreateEnvironmentProfileResponse,
  CreateFormTypeResponse,
  GetDomainResponse,
  ListEnvironmentBlueprintConfigurationsResponse,
  EnvironmentBlueprintConfigurationItem,
  DeleteSubscriptionRequestResponse,
  ListSubscriptionGrantsResponse,
  SearchResultItem,
  AcceptPredictionsResponse,
  GetGlossaryResponse,
  ListDomainsResponse,
  CreateDomainResponse,
  CreateSubscriptionRequestResponse,
  EnvironmentBlueprintSummary,
  GroupProfileSummary,
  DeleteListingResponse,
  UpdateDomainResponse,
  GetUserProfileResponse,
  SubscriptionSummary,
  RevokeSubscriptionResponse,
  DeleteEnvironmentProfileResponse,
  UpdateGlossaryResponse,
  GetAssetTypeResponse,
  GetEnvironmentResponse,
  SearchGroupProfilesResponse,
  DeleteSubscriptionTargetResponse,
  ListDataSourceRunsResponse,
  ListProjectsResponse,
  CreateAssetResponse,
  GetEnvironmentBlueprintResponse,
  SearchTypesResponse,
  DeleteDataSourceResponse,
  SearchListingsResponse,
  SubscriptionRequestSummary,
  CreateGlossaryResponse,
  NotificationOutput,
  SearchTypesResultItem,
  GetDataSourceResponse,
  ListSubscriptionRequestsResponse,
  ListSubscriptionTargetsResponse,
  GetFormTypeResponse,
  CreateProjectMembershipResponse,
  GetDataSourceRunResponse,
  UpdateSubscriptionRequestResponse,
  UpdateEnvironmentResponse,
  CreateDataSourceResponse,
  ListEnvironmentProfilesResponse,
  GetAssetResponse,
  RejectPredictionsResponse,
  CreateGlossaryTermResponse,
  GetEnvironmentBlueprintConfigurationResponse,
  ListTagsForResourceResponse,
  DeleteGlossaryResponse,
  CreateSubscriptionGrantResponse,
  UntagResourceResponse,
  DeleteAssetTypeResponse,
  StartDataSourceRunResponse,
  UpdateSubscriptionTargetResponse,
  DeleteAssetResponse,
  CreateProjectResponse,
  GetGroupProfileResponse,
  ProjectMember,
  CreateSubscriptionTargetResponse,
  SearchUserProfilesResponse,
  AcceptSubscriptionRequestResponse,
  ListEnvironmentBlueprintsResponse,
  DeleteFormTypeResponse,
  CreateGroupProfileResponse,
  UpdateDataSourceResponse,
  DataSourceRunSummary,
  DataSourceRunActivity,
  UpdateSubscriptionGrantStatusResponse,
  DeleteProjectMembershipResponse,
  DataSourceSummary,
  GetEnvironmentProfileResponse,
  CreateAssetTypeResponse,
  DomainSummary,
  SearchResponse,
  ProjectSummary,
  UpdateEnvironmentProfileResponse,
  ListNotificationsResponse,
  UpdateUserProfileResponse,
  CreateListingChangeSetResponse,
  ListDataSourcesResponse,
  CreateUserProfileResponse,
  PutEnvironmentBlueprintConfigurationResponse,
  SubscriptionGrantSummary,
  UpdateGlossaryTermResponse,
  GetSubscriptionResponse,
  EnvironmentProfileSummary,
  GetGlossaryTermResponse,
  GetSubscriptionGrantResponse,
  ListDataSourceRunActivitiesResponse,
  AssetRevision,
  UpdateGroupProfileResponse,
  UpdateProjectResponse,
  TagResourceResponse,
  GetListingResponse,
  DeleteSubscriptionGrantResponse,
  DeleteProjectResponse,
  GetIamPortalLoginUrlResponse,
  ListEnvironmentsResponse,
  EnvironmentSummary,
  CreateEnvironmentResponse,
  SearchInventoryResultItem,
  CreateAssetRevisionResponse,
  RejectSubscriptionRequestResponse,
  DeleteDomainResponse,
  GetProjectResponse,
  DeleteEnvironmentResponse,
  DeleteGlossaryTermResponse,
  ListSubscriptionsResponse,
  ListAssetRevisionsResponse,
  ListProjectMembershipsResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait DataZone extends AspectSupport[DataZone] {
  val api: DataZoneAsyncClient
  def updateSubscriptionRequest(request: UpdateSubscriptionRequestRequest): IO[
    AwsError,
    zio.aws.datazone.model.UpdateSubscriptionRequestResponse.ReadOnly
  ]
  def deleteEnvironment(request: DeleteEnvironmentRequest): IO[AwsError, Unit]
  def createGlossaryTerm(
      request: CreateGlossaryTermRequest
  ): IO[AwsError, zio.aws.datazone.model.CreateGlossaryTermResponse.ReadOnly]
  def deleteSubscriptionTarget(
      request: DeleteSubscriptionTargetRequest
  ): IO[AwsError, Unit]
  def getProject(
      request: GetProjectRequest
  ): IO[AwsError, zio.aws.datazone.model.GetProjectResponse.ReadOnly]
  def getDataSource(
      request: GetDataSourceRequest
  ): IO[AwsError, zio.aws.datazone.model.GetDataSourceResponse.ReadOnly]
  def getGroupProfile(
      request: GetGroupProfileRequest
  ): IO[AwsError, zio.aws.datazone.model.GetGroupProfileResponse.ReadOnly]
  def listProjectMemberships(
      request: ListProjectMembershipsRequest
  ): ZStream[Any, AwsError, zio.aws.datazone.model.ProjectMember.ReadOnly]
  def listProjectMembershipsPaginated(
      request: ListProjectMembershipsRequest
  ): IO[
    AwsError,
    zio.aws.datazone.model.ListProjectMembershipsResponse.ReadOnly
  ]
  def getDataSourceRun(
      request: GetDataSourceRunRequest
  ): IO[AwsError, zio.aws.datazone.model.GetDataSourceRunResponse.ReadOnly]
  def createEnvironmentProfile(request: CreateEnvironmentProfileRequest): IO[
    AwsError,
    zio.aws.datazone.model.CreateEnvironmentProfileResponse.ReadOnly
  ]
  def listEnvironmentBlueprints(
      request: ListEnvironmentBlueprintsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.datazone.model.EnvironmentBlueprintSummary.ReadOnly
  ]
  def listEnvironmentBlueprintsPaginated(
      request: ListEnvironmentBlueprintsRequest
  ): IO[
    AwsError,
    zio.aws.datazone.model.ListEnvironmentBlueprintsResponse.ReadOnly
  ]
  def listSubscriptions(
      request: ListSubscriptionsRequest
  ): ZStream[Any, AwsError, zio.aws.datazone.model.SubscriptionSummary.ReadOnly]
  def listSubscriptionsPaginated(
      request: ListSubscriptionsRequest
  ): IO[AwsError, ReadOnly]
  def createAssetType(
      request: CreateAssetTypeRequest
  ): IO[AwsError, zio.aws.datazone.model.CreateAssetTypeResponse.ReadOnly]
  def deleteEnvironmentBlueprintConfiguration(
      request: DeleteEnvironmentBlueprintConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.datazone.model.DeleteEnvironmentBlueprintConfigurationResponse.ReadOnly
  ]
  def listNotifications(
      request: ListNotificationsRequest
  ): ZStream[Any, AwsError, zio.aws.datazone.model.NotificationOutput.ReadOnly]
  def listNotificationsPaginated(
      request: ListNotificationsRequest
  ): IO[AwsError, zio.aws.datazone.model.ListNotificationsResponse.ReadOnly]
  def updateProject(
      request: UpdateProjectRequest
  ): IO[AwsError, zio.aws.datazone.model.UpdateProjectResponse.ReadOnly]
  def createEnvironment(
      request: CreateEnvironmentRequest
  ): IO[AwsError, zio.aws.datazone.model.CreateEnvironmentResponse.ReadOnly]
  def listSubscriptionTargets(request: ListSubscriptionTargetsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.datazone.model.SubscriptionTargetSummary.ReadOnly
  ]
  def listSubscriptionTargetsPaginated(
      request: ListSubscriptionTargetsRequest
  ): IO[
    AwsError,
    zio.aws.datazone.model.ListSubscriptionTargetsResponse.ReadOnly
  ]
  def searchListings(
      request: SearchListingsRequest
  ): ZStream[Any, AwsError, zio.aws.datazone.model.SearchResultItem.ReadOnly]
  def searchListingsPaginated(
      request: SearchListingsRequest
  ): IO[AwsError, zio.aws.datazone.model.SearchListingsResponse.ReadOnly]
  def startDataSourceRun(
      request: StartDataSourceRunRequest
  ): IO[AwsError, zio.aws.datazone.model.StartDataSourceRunResponse.ReadOnly]
  def getSubscriptionRequestDetails(
      request: GetSubscriptionRequestDetailsRequest
  ): IO[
    AwsError,
    zio.aws.datazone.model.GetSubscriptionRequestDetailsResponse.ReadOnly
  ]
  def getEnvironment(
      request: GetEnvironmentRequest
  ): IO[AwsError, zio.aws.datazone.model.GetEnvironmentResponse.ReadOnly]
  def createFormType(
      request: CreateFormTypeRequest
  ): IO[AwsError, zio.aws.datazone.model.CreateFormTypeResponse.ReadOnly]
  def createSubscriptionTarget(request: CreateSubscriptionTargetRequest): IO[
    AwsError,
    zio.aws.datazone.model.CreateSubscriptionTargetResponse.ReadOnly
  ]
  def getIamPortalLoginUrl(
      request: GetIamPortalLoginUrlRequest
  ): IO[AwsError, zio.aws.datazone.model.GetIamPortalLoginUrlResponse.ReadOnly]
  def createListingChangeSet(request: CreateListingChangeSetRequest): IO[
    AwsError,
    zio.aws.datazone.model.CreateListingChangeSetResponse.ReadOnly
  ]
  def revokeSubscription(
      request: RevokeSubscriptionRequest
  ): IO[AwsError, zio.aws.datazone.model.RevokeSubscriptionResponse.ReadOnly]
  def rejectPredictions(
      request: RejectPredictionsRequest
  ): IO[AwsError, zio.aws.datazone.model.RejectPredictionsResponse.ReadOnly]
  def deleteSubscriptionGrant(request: DeleteSubscriptionGrantRequest): IO[
    AwsError,
    zio.aws.datazone.model.DeleteSubscriptionGrantResponse.ReadOnly
  ]
  def getDomain(
      request: GetDomainRequest
  ): IO[AwsError, zio.aws.datazone.model.GetDomainResponse.ReadOnly]
  def listDataSourceRunActivities(
      request: ListDataSourceRunActivitiesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.datazone.model.DataSourceRunActivity.ReadOnly
  ]
  def listDataSourceRunActivitiesPaginated(
      request: ListDataSourceRunActivitiesRequest
  ): IO[
    AwsError,
    zio.aws.datazone.model.ListDataSourceRunActivitiesResponse.ReadOnly
  ]
  def createGroupProfile(
      request: CreateGroupProfileRequest
  ): IO[AwsError, zio.aws.datazone.model.CreateGroupProfileResponse.ReadOnly]
  def updateUserProfile(
      request: UpdateUserProfileRequest
  ): IO[AwsError, zio.aws.datazone.model.UpdateUserProfileResponse.ReadOnly]
  def listSubscriptionRequests(
      request: ListSubscriptionRequestsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.datazone.model.SubscriptionRequestSummary.ReadOnly
  ]
  def listSubscriptionRequestsPaginated(
      request: ListSubscriptionRequestsRequest
  ): IO[
    AwsError,
    zio.aws.datazone.model.ListSubscriptionRequestsResponse.ReadOnly
  ]
  def getFormType(
      request: GetFormTypeRequest
  ): IO[AwsError, zio.aws.datazone.model.GetFormTypeResponse.ReadOnly]
  def getSubscription(
      request: GetSubscriptionRequest
  ): IO[AwsError, zio.aws.datazone.model.GetSubscriptionResponse.ReadOnly]
  def createDataSource(
      request: CreateDataSourceRequest
  ): IO[AwsError, zio.aws.datazone.model.CreateDataSourceResponse.ReadOnly]
  def listDomains(
      request: ListDomainsRequest
  ): ZStream[Any, AwsError, zio.aws.datazone.model.DomainSummary.ReadOnly]
  def listDomainsPaginated(
      request: ListDomainsRequest
  ): IO[AwsError, zio.aws.datazone.model.ListDomainsResponse.ReadOnly]
  def deleteGlossaryTerm(
      request: DeleteGlossaryTermRequest
  ): IO[AwsError, zio.aws.datazone.model.DeleteGlossaryTermResponse.ReadOnly]
  def updateSubscriptionGrantStatus(
      request: UpdateSubscriptionGrantStatusRequest
  ): IO[
    AwsError,
    zio.aws.datazone.model.UpdateSubscriptionGrantStatusResponse.ReadOnly
  ]
  def putEnvironmentBlueprintConfiguration(
      request: PutEnvironmentBlueprintConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.datazone.model.PutEnvironmentBlueprintConfigurationResponse.ReadOnly
  ]
  def createSubscriptionGrant(request: CreateSubscriptionGrantRequest): IO[
    AwsError,
    zio.aws.datazone.model.CreateSubscriptionGrantResponse.ReadOnly
  ]
  def updateGroupProfile(
      request: UpdateGroupProfileRequest
  ): IO[AwsError, zio.aws.datazone.model.UpdateGroupProfileResponse.ReadOnly]
  def getGlossaryTerm(
      request: GetGlossaryTermRequest
  ): IO[AwsError, zio.aws.datazone.model.GetGlossaryTermResponse.ReadOnly]
  def listProjects(
      request: ListProjectsRequest
  ): ZStream[Any, AwsError, zio.aws.datazone.model.ProjectSummary.ReadOnly]
  def listProjectsPaginated(
      request: ListProjectsRequest
  ): IO[AwsError, zio.aws.datazone.model.ListProjectsResponse.ReadOnly]
  def getSubscriptionTarget(
      request: GetSubscriptionTargetRequest
  ): IO[AwsError, zio.aws.datazone.model.GetSubscriptionTargetResponse.ReadOnly]
  def listEnvironmentProfiles(request: ListEnvironmentProfilesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.datazone.model.EnvironmentProfileSummary.ReadOnly
  ]
  def listEnvironmentProfilesPaginated(
      request: ListEnvironmentProfilesRequest
  ): IO[
    AwsError,
    zio.aws.datazone.model.ListEnvironmentProfilesResponse.ReadOnly
  ]
  def listDataSourceRuns(request: ListDataSourceRunsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.datazone.model.DataSourceRunSummary.ReadOnly
  ]
  def listDataSourceRunsPaginated(
      request: ListDataSourceRunsRequest
  ): IO[AwsError, zio.aws.datazone.model.ListDataSourceRunsResponse.ReadOnly]
  def createAssetRevision(
      request: CreateAssetRevisionRequest
  ): IO[AwsError, zio.aws.datazone.model.CreateAssetRevisionResponse.ReadOnly]
  def updateGlossary(
      request: UpdateGlossaryRequest
  ): IO[AwsError, zio.aws.datazone.model.UpdateGlossaryResponse.ReadOnly]
  def getSubscriptionGrant(
      request: GetSubscriptionGrantRequest
  ): IO[AwsError, zio.aws.datazone.model.GetSubscriptionGrantResponse.ReadOnly]
  def listDataSources(
      request: ListDataSourcesRequest
  ): ZStream[Any, AwsError, zio.aws.datazone.model.DataSourceSummary.ReadOnly]
  def listDataSourcesPaginated(
      request: ListDataSourcesRequest
  ): IO[AwsError, zio.aws.datazone.model.ListDataSourcesResponse.ReadOnly]
  def getEnvironmentProfile(
      request: GetEnvironmentProfileRequest
  ): IO[AwsError, zio.aws.datazone.model.GetEnvironmentProfileResponse.ReadOnly]
  def searchUserProfiles(
      request: SearchUserProfilesRequest
  ): ZStream[Any, AwsError, zio.aws.datazone.model.UserProfileSummary.ReadOnly]
  def searchUserProfilesPaginated(
      request: SearchUserProfilesRequest
  ): IO[AwsError, zio.aws.datazone.model.SearchUserProfilesResponse.ReadOnly]
  def acceptPredictions(
      request: AcceptPredictionsRequest
  ): IO[AwsError, zio.aws.datazone.model.AcceptPredictionsResponse.ReadOnly]
  def getListing(
      request: GetListingRequest
  ): IO[AwsError, zio.aws.datazone.model.GetListingResponse.ReadOnly]
  def getEnvironmentBlueprintConfiguration(
      request: GetEnvironmentBlueprintConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.datazone.model.GetEnvironmentBlueprintConfigurationResponse.ReadOnly
  ]
  def updateEnvironmentProfile(request: UpdateEnvironmentProfileRequest): IO[
    AwsError,
    zio.aws.datazone.model.UpdateEnvironmentProfileResponse.ReadOnly
  ]
  def createDomain(
      request: CreateDomainRequest
  ): IO[AwsError, zio.aws.datazone.model.CreateDomainResponse.ReadOnly]
  def listAssetRevisions(
      request: ListAssetRevisionsRequest
  ): ZStream[Any, AwsError, zio.aws.datazone.model.AssetRevision.ReadOnly]
  def listAssetRevisionsPaginated(
      request: ListAssetRevisionsRequest
  ): IO[AwsError, zio.aws.datazone.model.ListAssetRevisionsResponse.ReadOnly]
  def deleteFormType(
      request: DeleteFormTypeRequest
  ): IO[AwsError, zio.aws.datazone.model.DeleteFormTypeResponse.ReadOnly]
  def searchTypes(request: SearchTypesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.datazone.model.SearchTypesResultItem.ReadOnly
  ]
  def searchTypesPaginated(
      request: SearchTypesRequest
  ): IO[AwsError, zio.aws.datazone.model.SearchTypesResponse.ReadOnly]
  def getGlossary(
      request: GetGlossaryRequest
  ): IO[AwsError, zio.aws.datazone.model.GetGlossaryResponse.ReadOnly]
  def createAsset(
      request: CreateAssetRequest
  ): IO[AwsError, zio.aws.datazone.model.CreateAssetResponse.ReadOnly]
  def listEnvironments(
      request: ListEnvironmentsRequest
  ): ZStream[Any, AwsError, zio.aws.datazone.model.EnvironmentSummary.ReadOnly]
  def listEnvironmentsPaginated(
      request: ListEnvironmentsRequest
  ): IO[AwsError, zio.aws.datazone.model.ListEnvironmentsResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.datazone.model.UntagResourceResponse.ReadOnly]
  def createProject(
      request: CreateProjectRequest
  ): IO[AwsError, zio.aws.datazone.model.CreateProjectResponse.ReadOnly]
  def updateDomain(
      request: UpdateDomainRequest
  ): IO[AwsError, zio.aws.datazone.model.UpdateDomainResponse.ReadOnly]
  def updateDataSource(
      request: UpdateDataSourceRequest
  ): IO[AwsError, zio.aws.datazone.model.UpdateDataSourceResponse.ReadOnly]
  def listEnvironmentBlueprintConfigurations(
      request: ListEnvironmentBlueprintConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem.ReadOnly
  ]
  def listEnvironmentBlueprintConfigurationsPaginated(
      request: ListEnvironmentBlueprintConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsResponse.ReadOnly
  ]
  def deleteDataSource(
      request: DeleteDataSourceRequest
  ): IO[AwsError, zio.aws.datazone.model.DeleteDataSourceResponse.ReadOnly]
  def getUserProfile(
      request: GetUserProfileRequest
  ): IO[AwsError, zio.aws.datazone.model.GetUserProfileResponse.ReadOnly]
  def getAsset(
      request: GetAssetRequest
  ): IO[AwsError, zio.aws.datazone.model.GetAssetResponse.ReadOnly]
  def getEnvironmentBlueprint(request: GetEnvironmentBlueprintRequest): IO[
    AwsError,
    zio.aws.datazone.model.GetEnvironmentBlueprintResponse.ReadOnly
  ]
  def updateGlossaryTerm(
      request: UpdateGlossaryTermRequest
  ): IO[AwsError, zio.aws.datazone.model.UpdateGlossaryTermResponse.ReadOnly]
  def listSubscriptionGrants(request: ListSubscriptionGrantsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.datazone.model.SubscriptionGrantSummary.ReadOnly
  ]
  def listSubscriptionGrantsPaginated(
      request: ListSubscriptionGrantsRequest
  ): IO[
    AwsError,
    zio.aws.datazone.model.ListSubscriptionGrantsResponse.ReadOnly
  ]
  def deleteAsset(
      request: DeleteAssetRequest
  ): IO[AwsError, zio.aws.datazone.model.DeleteAssetResponse.ReadOnly]
  def getAssetType(
      request: GetAssetTypeRequest
  ): IO[AwsError, zio.aws.datazone.model.GetAssetTypeResponse.ReadOnly]
  def deleteProjectMembership(request: DeleteProjectMembershipRequest): IO[
    AwsError,
    zio.aws.datazone.model.DeleteProjectMembershipResponse.ReadOnly
  ]
  def deleteSubscriptionRequest(
      request: DeleteSubscriptionRequestRequest
  ): IO[AwsError, Unit]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.datazone.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.datazone.model.TagResourceResponse.ReadOnly]
  def deleteDomain(
      request: DeleteDomainRequest
  ): IO[AwsError, zio.aws.datazone.model.DeleteDomainResponse.ReadOnly]
  def acceptSubscriptionRequest(request: AcceptSubscriptionRequestRequest): IO[
    AwsError,
    zio.aws.datazone.model.AcceptSubscriptionRequestResponse.ReadOnly
  ]
  def updateEnvironment(
      request: UpdateEnvironmentRequest
  ): IO[AwsError, zio.aws.datazone.model.UpdateEnvironmentResponse.ReadOnly]
  def rejectSubscriptionRequest(request: RejectSubscriptionRequestRequest): IO[
    AwsError,
    zio.aws.datazone.model.RejectSubscriptionRequestResponse.ReadOnly
  ]
  def updateSubscriptionTarget(request: UpdateSubscriptionTargetRequest): IO[
    AwsError,
    zio.aws.datazone.model.UpdateSubscriptionTargetResponse.ReadOnly
  ]
  def search(request: SearchRequest): ZStream[
    Any,
    AwsError,
    zio.aws.datazone.model.SearchInventoryResultItem.ReadOnly
  ]
  def searchPaginated(
      request: SearchRequest
  ): IO[AwsError, zio.aws.datazone.model.SearchResponse.ReadOnly]
  def createSubscriptionRequest(request: CreateSubscriptionRequestRequest): IO[
    AwsError,
    zio.aws.datazone.model.CreateSubscriptionRequestResponse.ReadOnly
  ]
  def cancelSubscription(
      request: CancelSubscriptionRequest
  ): IO[AwsError, zio.aws.datazone.model.CancelSubscriptionResponse.ReadOnly]
  def deleteEnvironmentProfile(
      request: DeleteEnvironmentProfileRequest
  ): IO[AwsError, Unit]
  def createGlossary(
      request: CreateGlossaryRequest
  ): IO[AwsError, zio.aws.datazone.model.CreateGlossaryResponse.ReadOnly]
  def deleteProject(
      request: DeleteProjectRequest
  ): IO[AwsError, zio.aws.datazone.model.DeleteProjectResponse.ReadOnly]
  def deleteAssetType(
      request: DeleteAssetTypeRequest
  ): IO[AwsError, zio.aws.datazone.model.DeleteAssetTypeResponse.ReadOnly]
  def deleteListing(
      request: DeleteListingRequest
  ): IO[AwsError, zio.aws.datazone.model.DeleteListingResponse.ReadOnly]
  def deleteGlossary(
      request: DeleteGlossaryRequest
  ): IO[AwsError, zio.aws.datazone.model.DeleteGlossaryResponse.ReadOnly]
  def createProjectMembership(request: CreateProjectMembershipRequest): IO[
    AwsError,
    zio.aws.datazone.model.CreateProjectMembershipResponse.ReadOnly
  ]
  def createUserProfile(
      request: CreateUserProfileRequest
  ): IO[AwsError, zio.aws.datazone.model.CreateUserProfileResponse.ReadOnly]
  def searchGroupProfiles(
      request: SearchGroupProfilesRequest
  ): ZStream[Any, AwsError, zio.aws.datazone.model.GroupProfileSummary.ReadOnly]
  def searchGroupProfilesPaginated(
      request: SearchGroupProfilesRequest
  ): IO[AwsError, zio.aws.datazone.model.SearchGroupProfilesResponse.ReadOnly]
}
object DataZone {
  val live: ZLayer[AwsConfig, java.lang.Throwable, DataZone] = customized(
    identity
  )
  def customized(
      customization: DataZoneAsyncClientBuilder => DataZoneAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, DataZone] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: DataZoneAsyncClientBuilder => DataZoneAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, DataZone] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = DataZoneAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[DataZoneAsyncClient, DataZoneAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[DataZoneAsyncClient, DataZoneAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new DataZoneImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class DataZoneImpl[R](
      override val api: DataZoneAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends DataZone
      with AwsServiceBase[R] {
    override val serviceName: String = "DataZone"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DataZoneImpl[R1] = new DataZoneImpl(api, newAspect, r)
    def updateSubscriptionRequest(
        request: UpdateSubscriptionRequestRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.UpdateSubscriptionRequestResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.UpdateSubscriptionRequestRequest,
      UpdateSubscriptionRequestResponse
    ]("updateSubscriptionRequest", api.updateSubscriptionRequest)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.UpdateSubscriptionRequestResponse.wrap)
      .provideEnvironment(r)
    def deleteEnvironment(
        request: DeleteEnvironmentRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.DeleteEnvironmentRequest,
      DeleteEnvironmentResponse
    ]("deleteEnvironment", api.deleteEnvironment)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def createGlossaryTerm(request: CreateGlossaryTermRequest): IO[
      AwsError,
      zio.aws.datazone.model.CreateGlossaryTermResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.CreateGlossaryTermRequest,
      CreateGlossaryTermResponse
    ]("createGlossaryTerm", api.createGlossaryTerm)(request.buildAwsValue())
      .map(zio.aws.datazone.model.CreateGlossaryTermResponse.wrap)
      .provideEnvironment(r)
    def deleteSubscriptionTarget(
        request: DeleteSubscriptionTargetRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.DeleteSubscriptionTargetRequest,
      DeleteSubscriptionTargetResponse
    ]("deleteSubscriptionTarget", api.deleteSubscriptionTarget)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getProject(
        request: GetProjectRequest
    ): IO[AwsError, zio.aws.datazone.model.GetProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.GetProjectRequest,
        GetProjectResponse
      ]("getProject", api.getProject)(request.buildAwsValue())
        .map(zio.aws.datazone.model.GetProjectResponse.wrap)
        .provideEnvironment(r)
    def getDataSource(
        request: GetDataSourceRequest
    ): IO[AwsError, zio.aws.datazone.model.GetDataSourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.GetDataSourceRequest,
        GetDataSourceResponse
      ]("getDataSource", api.getDataSource)(request.buildAwsValue())
        .map(zio.aws.datazone.model.GetDataSourceResponse.wrap)
        .provideEnvironment(r)
    def getGroupProfile(
        request: GetGroupProfileRequest
    ): IO[AwsError, zio.aws.datazone.model.GetGroupProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.GetGroupProfileRequest,
        GetGroupProfileResponse
      ]("getGroupProfile", api.getGroupProfile)(request.buildAwsValue())
        .map(zio.aws.datazone.model.GetGroupProfileResponse.wrap)
        .provideEnvironment(r)
    def listProjectMemberships(
        request: ListProjectMembershipsRequest
    ): ZStream[Any, AwsError, zio.aws.datazone.model.ProjectMember.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest,
        ProjectMember,
        ListProjectMembershipsPublisher
      ](
        "listProjectMemberships",
        api.listProjectMembershipsPaginator,
        _.members()
      )(request.buildAwsValue())
        .map(item => zio.aws.datazone.model.ProjectMember.wrap(item))
        .provideEnvironment(r)
    def listProjectMembershipsPaginated(
        request: ListProjectMembershipsRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.ListProjectMembershipsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest,
      ListProjectMembershipsResponse
    ]("listProjectMemberships", api.listProjectMemberships)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.ListProjectMembershipsResponse.wrap)
      .provideEnvironment(r)
    def getDataSourceRun(
        request: GetDataSourceRunRequest
    ): IO[AwsError, zio.aws.datazone.model.GetDataSourceRunResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.GetDataSourceRunRequest,
        GetDataSourceRunResponse
      ]("getDataSourceRun", api.getDataSourceRun)(request.buildAwsValue())
        .map(zio.aws.datazone.model.GetDataSourceRunResponse.wrap)
        .provideEnvironment(r)
    def createEnvironmentProfile(request: CreateEnvironmentProfileRequest): IO[
      AwsError,
      zio.aws.datazone.model.CreateEnvironmentProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.CreateEnvironmentProfileRequest,
      CreateEnvironmentProfileResponse
    ]("createEnvironmentProfile", api.createEnvironmentProfile)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.CreateEnvironmentProfileResponse.wrap)
      .provideEnvironment(r)
    def listEnvironmentBlueprints(
        request: ListEnvironmentBlueprintsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.EnvironmentBlueprintSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest,
      EnvironmentBlueprintSummary,
      ListEnvironmentBlueprintsPublisher
    ](
      "listEnvironmentBlueprints",
      api.listEnvironmentBlueprintsPaginator,
      _.items()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.datazone.model.EnvironmentBlueprintSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listEnvironmentBlueprintsPaginated(
        request: ListEnvironmentBlueprintsRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.ListEnvironmentBlueprintsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest,
      ListEnvironmentBlueprintsResponse
    ]("listEnvironmentBlueprints", api.listEnvironmentBlueprints)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.ListEnvironmentBlueprintsResponse.wrap)
      .provideEnvironment(r)
    def listSubscriptions(request: ListSubscriptionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.SubscriptionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest,
      SubscriptionSummary,
      ListSubscriptionsPublisher
    ]("listSubscriptions", api.listSubscriptionsPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.datazone.model.SubscriptionSummary.wrap(item))
      .provideEnvironment(r)
    def listSubscriptionsPaginated(
        request: ListSubscriptionsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest,
      ListSubscriptionsResponse
    ]("listSubscriptions", api.listSubscriptions)(request.buildAwsValue())
      .map(zio.aws.datazone.model.ListSubscriptionsResponse.wrap)
      .provideEnvironment(r)
    def createAssetType(
        request: CreateAssetTypeRequest
    ): IO[AwsError, zio.aws.datazone.model.CreateAssetTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.CreateAssetTypeRequest,
        CreateAssetTypeResponse
      ]("createAssetType", api.createAssetType)(request.buildAwsValue())
        .map(zio.aws.datazone.model.CreateAssetTypeResponse.wrap)
        .provideEnvironment(r)
    def deleteEnvironmentBlueprintConfiguration(
        request: DeleteEnvironmentBlueprintConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.DeleteEnvironmentBlueprintConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest,
      DeleteEnvironmentBlueprintConfigurationResponse
    ](
      "deleteEnvironmentBlueprintConfiguration",
      api.deleteEnvironmentBlueprintConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.datazone.model.DeleteEnvironmentBlueprintConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def listNotifications(request: ListNotificationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.NotificationOutput.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.ListNotificationsRequest,
      NotificationOutput,
      ListNotificationsPublisher
    ]("listNotifications", api.listNotificationsPaginator, _.notifications())(
      request.buildAwsValue()
    ).map(item => zio.aws.datazone.model.NotificationOutput.wrap(item))
      .provideEnvironment(r)
    def listNotificationsPaginated(
        request: ListNotificationsRequest
    ): IO[AwsError, zio.aws.datazone.model.ListNotificationsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.ListNotificationsRequest,
        ListNotificationsResponse
      ]("listNotifications", api.listNotifications)(request.buildAwsValue())
        .map(zio.aws.datazone.model.ListNotificationsResponse.wrap)
        .provideEnvironment(r)
    def updateProject(
        request: UpdateProjectRequest
    ): IO[AwsError, zio.aws.datazone.model.UpdateProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.UpdateProjectRequest,
        UpdateProjectResponse
      ]("updateProject", api.updateProject)(request.buildAwsValue())
        .map(zio.aws.datazone.model.UpdateProjectResponse.wrap)
        .provideEnvironment(r)
    def createEnvironment(
        request: CreateEnvironmentRequest
    ): IO[AwsError, zio.aws.datazone.model.CreateEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.CreateEnvironmentRequest,
        CreateEnvironmentResponse
      ]("createEnvironment", api.createEnvironment)(request.buildAwsValue())
        .map(zio.aws.datazone.model.CreateEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def listSubscriptionTargets(
        request: ListSubscriptionTargetsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.SubscriptionTargetSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest,
      SubscriptionTargetSummary,
      ListSubscriptionTargetsPublisher
    ](
      "listSubscriptionTargets",
      api.listSubscriptionTargetsPaginator,
      _.items()
    )(request.buildAwsValue())
      .map(item => zio.aws.datazone.model.SubscriptionTargetSummary.wrap(item))
      .provideEnvironment(r)
    def listSubscriptionTargetsPaginated(
        request: ListSubscriptionTargetsRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.ListSubscriptionTargetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest,
      ListSubscriptionTargetsResponse
    ]("listSubscriptionTargets", api.listSubscriptionTargets)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.ListSubscriptionTargetsResponse.wrap)
      .provideEnvironment(r)
    def searchListings(request: SearchListingsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.SearchResultItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.SearchListingsRequest,
      SearchResultItem,
      SearchListingsPublisher
    ]("searchListings", api.searchListingsPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.datazone.model.SearchResultItem.wrap(item))
      .provideEnvironment(r)
    def searchListingsPaginated(
        request: SearchListingsRequest
    ): IO[AwsError, zio.aws.datazone.model.SearchListingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.SearchListingsRequest,
        SearchListingsResponse
      ]("searchListings", api.searchListings)(request.buildAwsValue())
        .map(zio.aws.datazone.model.SearchListingsResponse.wrap)
        .provideEnvironment(r)
    def startDataSourceRun(request: StartDataSourceRunRequest): IO[
      AwsError,
      zio.aws.datazone.model.StartDataSourceRunResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.StartDataSourceRunRequest,
      StartDataSourceRunResponse
    ]("startDataSourceRun", api.startDataSourceRun)(request.buildAwsValue())
      .map(zio.aws.datazone.model.StartDataSourceRunResponse.wrap)
      .provideEnvironment(r)
    def getSubscriptionRequestDetails(
        request: GetSubscriptionRequestDetailsRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.GetSubscriptionRequestDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.GetSubscriptionRequestDetailsRequest,
      GetSubscriptionRequestDetailsResponse
    ]("getSubscriptionRequestDetails", api.getSubscriptionRequestDetails)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.GetSubscriptionRequestDetailsResponse.wrap)
      .provideEnvironment(r)
    def getEnvironment(
        request: GetEnvironmentRequest
    ): IO[AwsError, zio.aws.datazone.model.GetEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.GetEnvironmentRequest,
        GetEnvironmentResponse
      ]("getEnvironment", api.getEnvironment)(request.buildAwsValue())
        .map(zio.aws.datazone.model.GetEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def createFormType(
        request: CreateFormTypeRequest
    ): IO[AwsError, zio.aws.datazone.model.CreateFormTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.CreateFormTypeRequest,
        CreateFormTypeResponse
      ]("createFormType", api.createFormType)(request.buildAwsValue())
        .map(zio.aws.datazone.model.CreateFormTypeResponse.wrap)
        .provideEnvironment(r)
    def createSubscriptionTarget(request: CreateSubscriptionTargetRequest): IO[
      AwsError,
      zio.aws.datazone.model.CreateSubscriptionTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetRequest,
      CreateSubscriptionTargetResponse
    ]("createSubscriptionTarget", api.createSubscriptionTarget)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.CreateSubscriptionTargetResponse.wrap)
      .provideEnvironment(r)
    def getIamPortalLoginUrl(request: GetIamPortalLoginUrlRequest): IO[
      AwsError,
      zio.aws.datazone.model.GetIamPortalLoginUrlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.GetIamPortalLoginUrlRequest,
      GetIamPortalLoginUrlResponse
    ]("getIamPortalLoginUrl", api.getIamPortalLoginUrl)(request.buildAwsValue())
      .map(zio.aws.datazone.model.GetIamPortalLoginUrlResponse.wrap)
      .provideEnvironment(r)
    def createListingChangeSet(request: CreateListingChangeSetRequest): IO[
      AwsError,
      zio.aws.datazone.model.CreateListingChangeSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.CreateListingChangeSetRequest,
      CreateListingChangeSetResponse
    ]("createListingChangeSet", api.createListingChangeSet)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.CreateListingChangeSetResponse.wrap)
      .provideEnvironment(r)
    def revokeSubscription(request: RevokeSubscriptionRequest): IO[
      AwsError,
      zio.aws.datazone.model.RevokeSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.RevokeSubscriptionRequest,
      RevokeSubscriptionResponse
    ]("revokeSubscription", api.revokeSubscription)(request.buildAwsValue())
      .map(zio.aws.datazone.model.RevokeSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def rejectPredictions(
        request: RejectPredictionsRequest
    ): IO[AwsError, zio.aws.datazone.model.RejectPredictionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.RejectPredictionsRequest,
        RejectPredictionsResponse
      ]("rejectPredictions", api.rejectPredictions)(request.buildAwsValue())
        .map(zio.aws.datazone.model.RejectPredictionsResponse.wrap)
        .provideEnvironment(r)
    def deleteSubscriptionGrant(request: DeleteSubscriptionGrantRequest): IO[
      AwsError,
      zio.aws.datazone.model.DeleteSubscriptionGrantResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.DeleteSubscriptionGrantRequest,
      DeleteSubscriptionGrantResponse
    ]("deleteSubscriptionGrant", api.deleteSubscriptionGrant)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.DeleteSubscriptionGrantResponse.wrap)
      .provideEnvironment(r)
    def getDomain(
        request: GetDomainRequest
    ): IO[AwsError, zio.aws.datazone.model.GetDomainResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.GetDomainRequest,
        GetDomainResponse
      ]("getDomain", api.getDomain)(request.buildAwsValue())
        .map(zio.aws.datazone.model.GetDomainResponse.wrap)
        .provideEnvironment(r)
    def listDataSourceRunActivities(
        request: ListDataSourceRunActivitiesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.DataSourceRunActivity.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest,
      DataSourceRunActivity,
      ListDataSourceRunActivitiesPublisher
    ](
      "listDataSourceRunActivities",
      api.listDataSourceRunActivitiesPaginator,
      _.items()
    )(request.buildAwsValue())
      .map(item => zio.aws.datazone.model.DataSourceRunActivity.wrap(item))
      .provideEnvironment(r)
    def listDataSourceRunActivitiesPaginated(
        request: ListDataSourceRunActivitiesRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.ListDataSourceRunActivitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest,
      ListDataSourceRunActivitiesResponse
    ]("listDataSourceRunActivities", api.listDataSourceRunActivities)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.ListDataSourceRunActivitiesResponse.wrap)
      .provideEnvironment(r)
    def createGroupProfile(request: CreateGroupProfileRequest): IO[
      AwsError,
      zio.aws.datazone.model.CreateGroupProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.CreateGroupProfileRequest,
      CreateGroupProfileResponse
    ]("createGroupProfile", api.createGroupProfile)(request.buildAwsValue())
      .map(zio.aws.datazone.model.CreateGroupProfileResponse.wrap)
      .provideEnvironment(r)
    def updateUserProfile(
        request: UpdateUserProfileRequest
    ): IO[AwsError, zio.aws.datazone.model.UpdateUserProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.UpdateUserProfileRequest,
        UpdateUserProfileResponse
      ]("updateUserProfile", api.updateUserProfile)(request.buildAwsValue())
        .map(zio.aws.datazone.model.UpdateUserProfileResponse.wrap)
        .provideEnvironment(r)
    def listSubscriptionRequests(
        request: ListSubscriptionRequestsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.SubscriptionRequestSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest,
      SubscriptionRequestSummary,
      ListSubscriptionRequestsPublisher
    ](
      "listSubscriptionRequests",
      api.listSubscriptionRequestsPaginator,
      _.items()
    )(request.buildAwsValue())
      .map(item => zio.aws.datazone.model.SubscriptionRequestSummary.wrap(item))
      .provideEnvironment(r)
    def listSubscriptionRequestsPaginated(
        request: ListSubscriptionRequestsRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.ListSubscriptionRequestsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest,
      ListSubscriptionRequestsResponse
    ]("listSubscriptionRequests", api.listSubscriptionRequests)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.ListSubscriptionRequestsResponse.wrap)
      .provideEnvironment(r)
    def getFormType(
        request: GetFormTypeRequest
    ): IO[AwsError, zio.aws.datazone.model.GetFormTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.GetFormTypeRequest,
        GetFormTypeResponse
      ]("getFormType", api.getFormType)(request.buildAwsValue())
        .map(zio.aws.datazone.model.GetFormTypeResponse.wrap)
        .provideEnvironment(r)
    def getSubscription(
        request: GetSubscriptionRequest
    ): IO[AwsError, zio.aws.datazone.model.GetSubscriptionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.GetSubscriptionRequest,
        GetSubscriptionResponse
      ]("getSubscription", api.getSubscription)(request.buildAwsValue())
        .map(zio.aws.datazone.model.GetSubscriptionResponse.wrap)
        .provideEnvironment(r)
    def createDataSource(
        request: CreateDataSourceRequest
    ): IO[AwsError, zio.aws.datazone.model.CreateDataSourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.CreateDataSourceRequest,
        CreateDataSourceResponse
      ]("createDataSource", api.createDataSource)(request.buildAwsValue())
        .map(zio.aws.datazone.model.CreateDataSourceResponse.wrap)
        .provideEnvironment(r)
    def listDomains(
        request: ListDomainsRequest
    ): ZStream[Any, AwsError, zio.aws.datazone.model.DomainSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.datazone.model.ListDomainsRequest,
        DomainSummary,
        ListDomainsPublisher
      ]("listDomains", api.listDomainsPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.datazone.model.DomainSummary.wrap(item))
        .provideEnvironment(r)
    def listDomainsPaginated(
        request: ListDomainsRequest
    ): IO[AwsError, zio.aws.datazone.model.ListDomainsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.ListDomainsRequest,
        ListDomainsResponse
      ]("listDomains", api.listDomains)(request.buildAwsValue())
        .map(zio.aws.datazone.model.ListDomainsResponse.wrap)
        .provideEnvironment(r)
    def deleteGlossaryTerm(request: DeleteGlossaryTermRequest): IO[
      AwsError,
      zio.aws.datazone.model.DeleteGlossaryTermResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.DeleteGlossaryTermRequest,
      DeleteGlossaryTermResponse
    ]("deleteGlossaryTerm", api.deleteGlossaryTerm)(request.buildAwsValue())
      .map(zio.aws.datazone.model.DeleteGlossaryTermResponse.wrap)
      .provideEnvironment(r)
    def updateSubscriptionGrantStatus(
        request: UpdateSubscriptionGrantStatusRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.UpdateSubscriptionGrantStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.UpdateSubscriptionGrantStatusRequest,
      UpdateSubscriptionGrantStatusResponse
    ]("updateSubscriptionGrantStatus", api.updateSubscriptionGrantStatus)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.UpdateSubscriptionGrantStatusResponse.wrap)
      .provideEnvironment(r)
    def putEnvironmentBlueprintConfiguration(
        request: PutEnvironmentBlueprintConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.PutEnvironmentBlueprintConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.PutEnvironmentBlueprintConfigurationRequest,
      PutEnvironmentBlueprintConfigurationResponse
    ](
      "putEnvironmentBlueprintConfiguration",
      api.putEnvironmentBlueprintConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.datazone.model.PutEnvironmentBlueprintConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def createSubscriptionGrant(request: CreateSubscriptionGrantRequest): IO[
      AwsError,
      zio.aws.datazone.model.CreateSubscriptionGrantResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.CreateSubscriptionGrantRequest,
      CreateSubscriptionGrantResponse
    ]("createSubscriptionGrant", api.createSubscriptionGrant)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.CreateSubscriptionGrantResponse.wrap)
      .provideEnvironment(r)
    def updateGroupProfile(request: UpdateGroupProfileRequest): IO[
      AwsError,
      zio.aws.datazone.model.UpdateGroupProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.UpdateGroupProfileRequest,
      UpdateGroupProfileResponse
    ]("updateGroupProfile", api.updateGroupProfile)(request.buildAwsValue())
      .map(zio.aws.datazone.model.UpdateGroupProfileResponse.wrap)
      .provideEnvironment(r)
    def getGlossaryTerm(
        request: GetGlossaryTermRequest
    ): IO[AwsError, zio.aws.datazone.model.GetGlossaryTermResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.GetGlossaryTermRequest,
        GetGlossaryTermResponse
      ]("getGlossaryTerm", api.getGlossaryTerm)(request.buildAwsValue())
        .map(zio.aws.datazone.model.GetGlossaryTermResponse.wrap)
        .provideEnvironment(r)
    def listProjects(
        request: ListProjectsRequest
    ): ZStream[Any, AwsError, zio.aws.datazone.model.ProjectSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.datazone.model.ListProjectsRequest,
        ProjectSummary,
        ListProjectsPublisher
      ]("listProjects", api.listProjectsPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.datazone.model.ProjectSummary.wrap(item))
        .provideEnvironment(r)
    def listProjectsPaginated(
        request: ListProjectsRequest
    ): IO[AwsError, zio.aws.datazone.model.ListProjectsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.ListProjectsRequest,
        ListProjectsResponse
      ]("listProjects", api.listProjects)(request.buildAwsValue())
        .map(zio.aws.datazone.model.ListProjectsResponse.wrap)
        .provideEnvironment(r)
    def getSubscriptionTarget(request: GetSubscriptionTargetRequest): IO[
      AwsError,
      zio.aws.datazone.model.GetSubscriptionTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.GetSubscriptionTargetRequest,
      GetSubscriptionTargetResponse
    ]("getSubscriptionTarget", api.getSubscriptionTarget)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.GetSubscriptionTargetResponse.wrap)
      .provideEnvironment(r)
    def listEnvironmentProfiles(
        request: ListEnvironmentProfilesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.EnvironmentProfileSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest,
      EnvironmentProfileSummary,
      ListEnvironmentProfilesPublisher
    ](
      "listEnvironmentProfiles",
      api.listEnvironmentProfilesPaginator,
      _.items()
    )(request.buildAwsValue())
      .map(item => zio.aws.datazone.model.EnvironmentProfileSummary.wrap(item))
      .provideEnvironment(r)
    def listEnvironmentProfilesPaginated(
        request: ListEnvironmentProfilesRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.ListEnvironmentProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest,
      ListEnvironmentProfilesResponse
    ]("listEnvironmentProfiles", api.listEnvironmentProfiles)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.ListEnvironmentProfilesResponse.wrap)
      .provideEnvironment(r)
    def listDataSourceRuns(request: ListDataSourceRunsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.DataSourceRunSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest,
      DataSourceRunSummary,
      ListDataSourceRunsPublisher
    ]("listDataSourceRuns", api.listDataSourceRunsPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.datazone.model.DataSourceRunSummary.wrap(item))
      .provideEnvironment(r)
    def listDataSourceRunsPaginated(request: ListDataSourceRunsRequest): IO[
      AwsError,
      zio.aws.datazone.model.ListDataSourceRunsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest,
      ListDataSourceRunsResponse
    ]("listDataSourceRuns", api.listDataSourceRuns)(request.buildAwsValue())
      .map(zio.aws.datazone.model.ListDataSourceRunsResponse.wrap)
      .provideEnvironment(r)
    def createAssetRevision(request: CreateAssetRevisionRequest): IO[
      AwsError,
      zio.aws.datazone.model.CreateAssetRevisionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.CreateAssetRevisionRequest,
      CreateAssetRevisionResponse
    ]("createAssetRevision", api.createAssetRevision)(request.buildAwsValue())
      .map(zio.aws.datazone.model.CreateAssetRevisionResponse.wrap)
      .provideEnvironment(r)
    def updateGlossary(
        request: UpdateGlossaryRequest
    ): IO[AwsError, zio.aws.datazone.model.UpdateGlossaryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.UpdateGlossaryRequest,
        UpdateGlossaryResponse
      ]("updateGlossary", api.updateGlossary)(request.buildAwsValue())
        .map(zio.aws.datazone.model.UpdateGlossaryResponse.wrap)
        .provideEnvironment(r)
    def getSubscriptionGrant(request: GetSubscriptionGrantRequest): IO[
      AwsError,
      zio.aws.datazone.model.GetSubscriptionGrantResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantRequest,
      GetSubscriptionGrantResponse
    ]("getSubscriptionGrant", api.getSubscriptionGrant)(request.buildAwsValue())
      .map(zio.aws.datazone.model.GetSubscriptionGrantResponse.wrap)
      .provideEnvironment(r)
    def listDataSources(request: ListDataSourcesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.DataSourceSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest,
      DataSourceSummary,
      ListDataSourcesPublisher
    ]("listDataSources", api.listDataSourcesPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.datazone.model.DataSourceSummary.wrap(item))
      .provideEnvironment(r)
    def listDataSourcesPaginated(
        request: ListDataSourcesRequest
    ): IO[AwsError, zio.aws.datazone.model.ListDataSourcesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest,
        ListDataSourcesResponse
      ]("listDataSources", api.listDataSources)(request.buildAwsValue())
        .map(zio.aws.datazone.model.ListDataSourcesResponse.wrap)
        .provideEnvironment(r)
    def getEnvironmentProfile(request: GetEnvironmentProfileRequest): IO[
      AwsError,
      zio.aws.datazone.model.GetEnvironmentProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileRequest,
      GetEnvironmentProfileResponse
    ]("getEnvironmentProfile", api.getEnvironmentProfile)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.GetEnvironmentProfileResponse.wrap)
      .provideEnvironment(r)
    def searchUserProfiles(request: SearchUserProfilesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.UserProfileSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest,
      UserProfileSummary,
      SearchUserProfilesPublisher
    ]("searchUserProfiles", api.searchUserProfilesPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.datazone.model.UserProfileSummary.wrap(item))
      .provideEnvironment(r)
    def searchUserProfilesPaginated(request: SearchUserProfilesRequest): IO[
      AwsError,
      zio.aws.datazone.model.SearchUserProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest,
      SearchUserProfilesResponse
    ]("searchUserProfiles", api.searchUserProfiles)(request.buildAwsValue())
      .map(zio.aws.datazone.model.SearchUserProfilesResponse.wrap)
      .provideEnvironment(r)
    def acceptPredictions(
        request: AcceptPredictionsRequest
    ): IO[AwsError, zio.aws.datazone.model.AcceptPredictionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.AcceptPredictionsRequest,
        AcceptPredictionsResponse
      ]("acceptPredictions", api.acceptPredictions)(request.buildAwsValue())
        .map(zio.aws.datazone.model.AcceptPredictionsResponse.wrap)
        .provideEnvironment(r)
    def getListing(
        request: GetListingRequest
    ): IO[AwsError, zio.aws.datazone.model.GetListingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.GetListingRequest,
        GetListingResponse
      ]("getListing", api.getListing)(request.buildAwsValue())
        .map(zio.aws.datazone.model.GetListingResponse.wrap)
        .provideEnvironment(r)
    def getEnvironmentBlueprintConfiguration(
        request: GetEnvironmentBlueprintConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.GetEnvironmentBlueprintConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintConfigurationRequest,
      GetEnvironmentBlueprintConfigurationResponse
    ](
      "getEnvironmentBlueprintConfiguration",
      api.getEnvironmentBlueprintConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.datazone.model.GetEnvironmentBlueprintConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def updateEnvironmentProfile(request: UpdateEnvironmentProfileRequest): IO[
      AwsError,
      zio.aws.datazone.model.UpdateEnvironmentProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.UpdateEnvironmentProfileRequest,
      UpdateEnvironmentProfileResponse
    ]("updateEnvironmentProfile", api.updateEnvironmentProfile)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.UpdateEnvironmentProfileResponse.wrap)
      .provideEnvironment(r)
    def createDomain(
        request: CreateDomainRequest
    ): IO[AwsError, zio.aws.datazone.model.CreateDomainResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.CreateDomainRequest,
        CreateDomainResponse
      ]("createDomain", api.createDomain)(request.buildAwsValue())
        .map(zio.aws.datazone.model.CreateDomainResponse.wrap)
        .provideEnvironment(r)
    def listAssetRevisions(request: ListAssetRevisionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.AssetRevision.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest,
      AssetRevision,
      ListAssetRevisionsPublisher
    ]("listAssetRevisions", api.listAssetRevisionsPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.datazone.model.AssetRevision.wrap(item))
      .provideEnvironment(r)
    def listAssetRevisionsPaginated(request: ListAssetRevisionsRequest): IO[
      AwsError,
      zio.aws.datazone.model.ListAssetRevisionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest,
      ListAssetRevisionsResponse
    ]("listAssetRevisions", api.listAssetRevisions)(request.buildAwsValue())
      .map(zio.aws.datazone.model.ListAssetRevisionsResponse.wrap)
      .provideEnvironment(r)
    def deleteFormType(
        request: DeleteFormTypeRequest
    ): IO[AwsError, zio.aws.datazone.model.DeleteFormTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.DeleteFormTypeRequest,
        DeleteFormTypeResponse
      ]("deleteFormType", api.deleteFormType)(request.buildAwsValue())
        .map(zio.aws.datazone.model.DeleteFormTypeResponse.wrap)
        .provideEnvironment(r)
    def searchTypes(request: SearchTypesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.SearchTypesResultItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.SearchTypesRequest,
      SearchTypesResultItem,
      SearchTypesPublisher
    ]("searchTypes", api.searchTypesPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.datazone.model.SearchTypesResultItem.wrap(item))
      .provideEnvironment(r)
    def searchTypesPaginated(
        request: SearchTypesRequest
    ): IO[AwsError, zio.aws.datazone.model.SearchTypesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.SearchTypesRequest,
        SearchTypesResponse
      ]("searchTypes", api.searchTypes)(request.buildAwsValue())
        .map(zio.aws.datazone.model.SearchTypesResponse.wrap)
        .provideEnvironment(r)
    def getGlossary(
        request: GetGlossaryRequest
    ): IO[AwsError, zio.aws.datazone.model.GetGlossaryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.GetGlossaryRequest,
        GetGlossaryResponse
      ]("getGlossary", api.getGlossary)(request.buildAwsValue())
        .map(zio.aws.datazone.model.GetGlossaryResponse.wrap)
        .provideEnvironment(r)
    def createAsset(
        request: CreateAssetRequest
    ): IO[AwsError, zio.aws.datazone.model.CreateAssetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.CreateAssetRequest,
        CreateAssetResponse
      ]("createAsset", api.createAsset)(request.buildAwsValue())
        .map(zio.aws.datazone.model.CreateAssetResponse.wrap)
        .provideEnvironment(r)
    def listEnvironments(request: ListEnvironmentsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.EnvironmentSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest,
      EnvironmentSummary,
      ListEnvironmentsPublisher
    ]("listEnvironments", api.listEnvironmentsPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.datazone.model.EnvironmentSummary.wrap(item))
      .provideEnvironment(r)
    def listEnvironmentsPaginated(
        request: ListEnvironmentsRequest
    ): IO[AwsError, zio.aws.datazone.model.ListEnvironmentsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest,
        ListEnvironmentsResponse
      ]("listEnvironments", api.listEnvironments)(request.buildAwsValue())
        .map(zio.aws.datazone.model.ListEnvironmentsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.datazone.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.datazone.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createProject(
        request: CreateProjectRequest
    ): IO[AwsError, zio.aws.datazone.model.CreateProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.CreateProjectRequest,
        CreateProjectResponse
      ]("createProject", api.createProject)(request.buildAwsValue())
        .map(zio.aws.datazone.model.CreateProjectResponse.wrap)
        .provideEnvironment(r)
    def updateDomain(
        request: UpdateDomainRequest
    ): IO[AwsError, zio.aws.datazone.model.UpdateDomainResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.UpdateDomainRequest,
        UpdateDomainResponse
      ]("updateDomain", api.updateDomain)(request.buildAwsValue())
        .map(zio.aws.datazone.model.UpdateDomainResponse.wrap)
        .provideEnvironment(r)
    def updateDataSource(
        request: UpdateDataSourceRequest
    ): IO[AwsError, zio.aws.datazone.model.UpdateDataSourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.UpdateDataSourceRequest,
        UpdateDataSourceResponse
      ]("updateDataSource", api.updateDataSource)(request.buildAwsValue())
        .map(zio.aws.datazone.model.UpdateDataSourceResponse.wrap)
        .provideEnvironment(r)
    def listEnvironmentBlueprintConfigurations(
        request: ListEnvironmentBlueprintConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest,
      EnvironmentBlueprintConfigurationItem,
      ListEnvironmentBlueprintConfigurationsPublisher
    ](
      "listEnvironmentBlueprintConfigurations",
      api.listEnvironmentBlueprintConfigurationsPaginator,
      _.items()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem.wrap(item)
      )
      .provideEnvironment(r)
    def listEnvironmentBlueprintConfigurationsPaginated(
        request: ListEnvironmentBlueprintConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest,
      ListEnvironmentBlueprintConfigurationsResponse
    ](
      "listEnvironmentBlueprintConfigurations",
      api.listEnvironmentBlueprintConfigurations
    )(request.buildAwsValue())
      .map(
        zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsResponse.wrap
      )
      .provideEnvironment(r)
    def deleteDataSource(
        request: DeleteDataSourceRequest
    ): IO[AwsError, zio.aws.datazone.model.DeleteDataSourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.DeleteDataSourceRequest,
        DeleteDataSourceResponse
      ]("deleteDataSource", api.deleteDataSource)(request.buildAwsValue())
        .map(zio.aws.datazone.model.DeleteDataSourceResponse.wrap)
        .provideEnvironment(r)
    def getUserProfile(
        request: GetUserProfileRequest
    ): IO[AwsError, zio.aws.datazone.model.GetUserProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.GetUserProfileRequest,
        GetUserProfileResponse
      ]("getUserProfile", api.getUserProfile)(request.buildAwsValue())
        .map(zio.aws.datazone.model.GetUserProfileResponse.wrap)
        .provideEnvironment(r)
    def getAsset(
        request: GetAssetRequest
    ): IO[AwsError, zio.aws.datazone.model.GetAssetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.GetAssetRequest,
        GetAssetResponse
      ]("getAsset", api.getAsset)(request.buildAwsValue())
        .map(zio.aws.datazone.model.GetAssetResponse.wrap)
        .provideEnvironment(r)
    def getEnvironmentBlueprint(request: GetEnvironmentBlueprintRequest): IO[
      AwsError,
      zio.aws.datazone.model.GetEnvironmentBlueprintResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintRequest,
      GetEnvironmentBlueprintResponse
    ]("getEnvironmentBlueprint", api.getEnvironmentBlueprint)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.GetEnvironmentBlueprintResponse.wrap)
      .provideEnvironment(r)
    def updateGlossaryTerm(request: UpdateGlossaryTermRequest): IO[
      AwsError,
      zio.aws.datazone.model.UpdateGlossaryTermResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.UpdateGlossaryTermRequest,
      UpdateGlossaryTermResponse
    ]("updateGlossaryTerm", api.updateGlossaryTerm)(request.buildAwsValue())
      .map(zio.aws.datazone.model.UpdateGlossaryTermResponse.wrap)
      .provideEnvironment(r)
    def listSubscriptionGrants(request: ListSubscriptionGrantsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.SubscriptionGrantSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest,
      SubscriptionGrantSummary,
      ListSubscriptionGrantsPublisher
    ]("listSubscriptionGrants", api.listSubscriptionGrantsPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.datazone.model.SubscriptionGrantSummary.wrap(item))
      .provideEnvironment(r)
    def listSubscriptionGrantsPaginated(
        request: ListSubscriptionGrantsRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.ListSubscriptionGrantsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest,
      ListSubscriptionGrantsResponse
    ]("listSubscriptionGrants", api.listSubscriptionGrants)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.ListSubscriptionGrantsResponse.wrap)
      .provideEnvironment(r)
    def deleteAsset(
        request: DeleteAssetRequest
    ): IO[AwsError, zio.aws.datazone.model.DeleteAssetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.DeleteAssetRequest,
        DeleteAssetResponse
      ]("deleteAsset", api.deleteAsset)(request.buildAwsValue())
        .map(zio.aws.datazone.model.DeleteAssetResponse.wrap)
        .provideEnvironment(r)
    def getAssetType(
        request: GetAssetTypeRequest
    ): IO[AwsError, zio.aws.datazone.model.GetAssetTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.GetAssetTypeRequest,
        GetAssetTypeResponse
      ]("getAssetType", api.getAssetType)(request.buildAwsValue())
        .map(zio.aws.datazone.model.GetAssetTypeResponse.wrap)
        .provideEnvironment(r)
    def deleteProjectMembership(request: DeleteProjectMembershipRequest): IO[
      AwsError,
      zio.aws.datazone.model.DeleteProjectMembershipResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.DeleteProjectMembershipRequest,
      DeleteProjectMembershipResponse
    ]("deleteProjectMembership", api.deleteProjectMembership)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.DeleteProjectMembershipResponse.wrap)
      .provideEnvironment(r)
    def deleteSubscriptionRequest(
        request: DeleteSubscriptionRequestRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.DeleteSubscriptionRequestRequest,
      DeleteSubscriptionRequestResponse
    ]("deleteSubscriptionRequest", api.deleteSubscriptionRequest)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.datazone.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.datazone.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.datazone.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.datazone.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteDomain(
        request: DeleteDomainRequest
    ): IO[AwsError, zio.aws.datazone.model.DeleteDomainResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.DeleteDomainRequest,
        DeleteDomainResponse
      ]("deleteDomain", api.deleteDomain)(request.buildAwsValue())
        .map(zio.aws.datazone.model.DeleteDomainResponse.wrap)
        .provideEnvironment(r)
    def acceptSubscriptionRequest(
        request: AcceptSubscriptionRequestRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.AcceptSubscriptionRequestResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestRequest,
      AcceptSubscriptionRequestResponse
    ]("acceptSubscriptionRequest", api.acceptSubscriptionRequest)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.AcceptSubscriptionRequestResponse.wrap)
      .provideEnvironment(r)
    def updateEnvironment(
        request: UpdateEnvironmentRequest
    ): IO[AwsError, zio.aws.datazone.model.UpdateEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.UpdateEnvironmentRequest,
        UpdateEnvironmentResponse
      ]("updateEnvironment", api.updateEnvironment)(request.buildAwsValue())
        .map(zio.aws.datazone.model.UpdateEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def rejectSubscriptionRequest(
        request: RejectSubscriptionRequestRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.RejectSubscriptionRequestResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.RejectSubscriptionRequestRequest,
      RejectSubscriptionRequestResponse
    ]("rejectSubscriptionRequest", api.rejectSubscriptionRequest)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.RejectSubscriptionRequestResponse.wrap)
      .provideEnvironment(r)
    def updateSubscriptionTarget(request: UpdateSubscriptionTargetRequest): IO[
      AwsError,
      zio.aws.datazone.model.UpdateSubscriptionTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.UpdateSubscriptionTargetRequest,
      UpdateSubscriptionTargetResponse
    ]("updateSubscriptionTarget", api.updateSubscriptionTarget)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.UpdateSubscriptionTargetResponse.wrap)
      .provideEnvironment(r)
    def search(request: SearchRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.SearchInventoryResultItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.SearchRequest,
      SearchInventoryResultItem,
      SearchPublisher
    ]("search", api.searchPaginator, _.items())(request.buildAwsValue())
      .map(item => zio.aws.datazone.model.SearchInventoryResultItem.wrap(item))
      .provideEnvironment(r)
    def searchPaginated(
        request: SearchRequest
    ): IO[AwsError, zio.aws.datazone.model.SearchResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.SearchRequest,
        SearchResponse
      ]("search", api.search)(request.buildAwsValue())
        .map(zio.aws.datazone.model.SearchResponse.wrap)
        .provideEnvironment(r)
    def createSubscriptionRequest(
        request: CreateSubscriptionRequestRequest
    ): IO[
      AwsError,
      zio.aws.datazone.model.CreateSubscriptionRequestResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestRequest,
      CreateSubscriptionRequestResponse
    ]("createSubscriptionRequest", api.createSubscriptionRequest)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.CreateSubscriptionRequestResponse.wrap)
      .provideEnvironment(r)
    def cancelSubscription(request: CancelSubscriptionRequest): IO[
      AwsError,
      zio.aws.datazone.model.CancelSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.CancelSubscriptionRequest,
      CancelSubscriptionResponse
    ]("cancelSubscription", api.cancelSubscription)(request.buildAwsValue())
      .map(zio.aws.datazone.model.CancelSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def deleteEnvironmentProfile(
        request: DeleteEnvironmentProfileRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.DeleteEnvironmentProfileRequest,
      DeleteEnvironmentProfileResponse
    ]("deleteEnvironmentProfile", api.deleteEnvironmentProfile)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createGlossary(
        request: CreateGlossaryRequest
    ): IO[AwsError, zio.aws.datazone.model.CreateGlossaryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.CreateGlossaryRequest,
        CreateGlossaryResponse
      ]("createGlossary", api.createGlossary)(request.buildAwsValue())
        .map(zio.aws.datazone.model.CreateGlossaryResponse.wrap)
        .provideEnvironment(r)
    def deleteProject(
        request: DeleteProjectRequest
    ): IO[AwsError, zio.aws.datazone.model.DeleteProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.DeleteProjectRequest,
        DeleteProjectResponse
      ]("deleteProject", api.deleteProject)(request.buildAwsValue())
        .map(zio.aws.datazone.model.DeleteProjectResponse.wrap)
        .provideEnvironment(r)
    def deleteAssetType(
        request: DeleteAssetTypeRequest
    ): IO[AwsError, zio.aws.datazone.model.DeleteAssetTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.DeleteAssetTypeRequest,
        DeleteAssetTypeResponse
      ]("deleteAssetType", api.deleteAssetType)(request.buildAwsValue())
        .map(zio.aws.datazone.model.DeleteAssetTypeResponse.wrap)
        .provideEnvironment(r)
    def deleteListing(
        request: DeleteListingRequest
    ): IO[AwsError, zio.aws.datazone.model.DeleteListingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.DeleteListingRequest,
        DeleteListingResponse
      ]("deleteListing", api.deleteListing)(request.buildAwsValue())
        .map(zio.aws.datazone.model.DeleteListingResponse.wrap)
        .provideEnvironment(r)
    def deleteGlossary(
        request: DeleteGlossaryRequest
    ): IO[AwsError, zio.aws.datazone.model.DeleteGlossaryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.DeleteGlossaryRequest,
        DeleteGlossaryResponse
      ]("deleteGlossary", api.deleteGlossary)(request.buildAwsValue())
        .map(zio.aws.datazone.model.DeleteGlossaryResponse.wrap)
        .provideEnvironment(r)
    def createProjectMembership(request: CreateProjectMembershipRequest): IO[
      AwsError,
      zio.aws.datazone.model.CreateProjectMembershipResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.CreateProjectMembershipRequest,
      CreateProjectMembershipResponse
    ]("createProjectMembership", api.createProjectMembership)(
      request.buildAwsValue()
    ).map(zio.aws.datazone.model.CreateProjectMembershipResponse.wrap)
      .provideEnvironment(r)
    def createUserProfile(
        request: CreateUserProfileRequest
    ): IO[AwsError, zio.aws.datazone.model.CreateUserProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datazone.model.CreateUserProfileRequest,
        CreateUserProfileResponse
      ]("createUserProfile", api.createUserProfile)(request.buildAwsValue())
        .map(zio.aws.datazone.model.CreateUserProfileResponse.wrap)
        .provideEnvironment(r)
    def searchGroupProfiles(request: SearchGroupProfilesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datazone.model.GroupProfileSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest,
      GroupProfileSummary,
      SearchGroupProfilesPublisher
    ]("searchGroupProfiles", api.searchGroupProfilesPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.datazone.model.GroupProfileSummary.wrap(item))
      .provideEnvironment(r)
    def searchGroupProfilesPaginated(request: SearchGroupProfilesRequest): IO[
      AwsError,
      zio.aws.datazone.model.SearchGroupProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest,
      SearchGroupProfilesResponse
    ]("searchGroupProfiles", api.searchGroupProfiles)(request.buildAwsValue())
      .map(zio.aws.datazone.model.SearchGroupProfilesResponse.wrap)
      .provideEnvironment(r)
  }
  def updateSubscriptionRequest(request: UpdateSubscriptionRequestRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.UpdateSubscriptionRequestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSubscriptionRequest(request))
  def deleteEnvironment(
      request: DeleteEnvironmentRequest
  ): ZIO[zio.aws.datazone.DataZone, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteEnvironment(request))
  def createGlossaryTerm(request: CreateGlossaryTermRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateGlossaryTermResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGlossaryTerm(request))
  def deleteSubscriptionTarget(
      request: DeleteSubscriptionTargetRequest
  ): ZIO[zio.aws.datazone.DataZone, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSubscriptionTarget(request))
  def getProject(request: GetProjectRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getProject(request))
  def getDataSource(request: GetDataSourceRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataSource(request))
  def getGroupProfile(request: GetGroupProfileRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetGroupProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGroupProfile(request))
  def listProjectMemberships(request: ListProjectMembershipsRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ProjectMember.ReadOnly
  ] = ZStream.serviceWithStream(_.listProjectMemberships(request))
  def listProjectMembershipsPaginated(
      request: ListProjectMembershipsRequest
  ): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListProjectMembershipsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProjectMembershipsPaginated(request))
  def getDataSourceRun(request: GetDataSourceRunRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetDataSourceRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataSourceRun(request))
  def createEnvironmentProfile(request: CreateEnvironmentProfileRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateEnvironmentProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEnvironmentProfile(request))
  def listEnvironmentBlueprints(
      request: ListEnvironmentBlueprintsRequest
  ): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.EnvironmentBlueprintSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEnvironmentBlueprints(request))
  def listEnvironmentBlueprintsPaginated(
      request: ListEnvironmentBlueprintsRequest
  ): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListEnvironmentBlueprintsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironmentBlueprintsPaginated(request))
  def listSubscriptions(request: ListSubscriptionsRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.SubscriptionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSubscriptions(request))
  def listSubscriptionsPaginated(
      request: ListSubscriptionsRequest
  ): ZIO[zio.aws.datazone.DataZone, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listSubscriptionsPaginated(request))
  def createAssetType(request: CreateAssetTypeRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateAssetTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAssetType(request))
  def deleteEnvironmentBlueprintConfiguration(
      request: DeleteEnvironmentBlueprintConfigurationRequest
  ): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DeleteEnvironmentBlueprintConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEnvironmentBlueprintConfiguration(request))
  def listNotifications(request: ListNotificationsRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.NotificationOutput.ReadOnly
  ] = ZStream.serviceWithStream(_.listNotifications(request))
  def listNotificationsPaginated(request: ListNotificationsRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListNotificationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNotificationsPaginated(request))
  def updateProject(request: UpdateProjectRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.UpdateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProject(request))
  def createEnvironment(request: CreateEnvironmentRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEnvironment(request))
  def listSubscriptionTargets(request: ListSubscriptionTargetsRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.SubscriptionTargetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSubscriptionTargets(request))
  def listSubscriptionTargetsPaginated(
      request: ListSubscriptionTargetsRequest
  ): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListSubscriptionTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSubscriptionTargetsPaginated(request))
  def searchListings(request: SearchListingsRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.SearchResultItem.ReadOnly
  ] = ZStream.serviceWithStream(_.searchListings(request))
  def searchListingsPaginated(request: SearchListingsRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.SearchListingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchListingsPaginated(request))
  def startDataSourceRun(request: StartDataSourceRunRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.StartDataSourceRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDataSourceRun(request))
  def getSubscriptionRequestDetails(
      request: GetSubscriptionRequestDetailsRequest
  ): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetSubscriptionRequestDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSubscriptionRequestDetails(request))
  def getEnvironment(request: GetEnvironmentRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEnvironment(request))
  def createFormType(request: CreateFormTypeRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateFormTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFormType(request))
  def createSubscriptionTarget(request: CreateSubscriptionTargetRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateSubscriptionTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSubscriptionTarget(request))
  def getIamPortalLoginUrl(request: GetIamPortalLoginUrlRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetIamPortalLoginUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIamPortalLoginUrl(request))
  def createListingChangeSet(request: CreateListingChangeSetRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateListingChangeSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createListingChangeSet(request))
  def revokeSubscription(request: RevokeSubscriptionRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.RevokeSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.revokeSubscription(request))
  def rejectPredictions(request: RejectPredictionsRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.RejectPredictionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectPredictions(request))
  def deleteSubscriptionGrant(request: DeleteSubscriptionGrantRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DeleteSubscriptionGrantResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSubscriptionGrant(request))
  def getDomain(request: GetDomainRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDomain(request))
  def listDataSourceRunActivities(
      request: ListDataSourceRunActivitiesRequest
  ): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DataSourceRunActivity.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataSourceRunActivities(request))
  def listDataSourceRunActivitiesPaginated(
      request: ListDataSourceRunActivitiesRequest
  ): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListDataSourceRunActivitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataSourceRunActivitiesPaginated(request))
  def createGroupProfile(request: CreateGroupProfileRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateGroupProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGroupProfile(request))
  def updateUserProfile(request: UpdateUserProfileRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.UpdateUserProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUserProfile(request))
  def listSubscriptionRequests(
      request: ListSubscriptionRequestsRequest
  ): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.SubscriptionRequestSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSubscriptionRequests(request))
  def listSubscriptionRequestsPaginated(
      request: ListSubscriptionRequestsRequest
  ): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListSubscriptionRequestsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSubscriptionRequestsPaginated(request))
  def getFormType(request: GetFormTypeRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetFormTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFormType(request))
  def getSubscription(request: GetSubscriptionRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSubscription(request))
  def createDataSource(request: CreateDataSourceRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataSource(request))
  def listDomains(request: ListDomainsRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DomainSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDomains(request))
  def listDomainsPaginated(request: ListDomainsRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListDomainsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDomainsPaginated(request))
  def deleteGlossaryTerm(request: DeleteGlossaryTermRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DeleteGlossaryTermResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGlossaryTerm(request))
  def updateSubscriptionGrantStatus(
      request: UpdateSubscriptionGrantStatusRequest
  ): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.UpdateSubscriptionGrantStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSubscriptionGrantStatus(request))
  def putEnvironmentBlueprintConfiguration(
      request: PutEnvironmentBlueprintConfigurationRequest
  ): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.PutEnvironmentBlueprintConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putEnvironmentBlueprintConfiguration(request))
  def createSubscriptionGrant(request: CreateSubscriptionGrantRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateSubscriptionGrantResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSubscriptionGrant(request))
  def updateGroupProfile(request: UpdateGroupProfileRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.UpdateGroupProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGroupProfile(request))
  def getGlossaryTerm(request: GetGlossaryTermRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetGlossaryTermResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGlossaryTerm(request))
  def listProjects(request: ListProjectsRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ProjectSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProjects(request))
  def listProjectsPaginated(request: ListProjectsRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListProjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProjectsPaginated(request))
  def getSubscriptionTarget(request: GetSubscriptionTargetRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetSubscriptionTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSubscriptionTarget(request))
  def listEnvironmentProfiles(request: ListEnvironmentProfilesRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.EnvironmentProfileSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEnvironmentProfiles(request))
  def listEnvironmentProfilesPaginated(
      request: ListEnvironmentProfilesRequest
  ): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListEnvironmentProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironmentProfilesPaginated(request))
  def listDataSourceRuns(request: ListDataSourceRunsRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DataSourceRunSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataSourceRuns(request))
  def listDataSourceRunsPaginated(request: ListDataSourceRunsRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListDataSourceRunsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataSourceRunsPaginated(request))
  def createAssetRevision(request: CreateAssetRevisionRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateAssetRevisionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAssetRevision(request))
  def updateGlossary(request: UpdateGlossaryRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.UpdateGlossaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGlossary(request))
  def getSubscriptionGrant(request: GetSubscriptionGrantRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetSubscriptionGrantResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSubscriptionGrant(request))
  def listDataSources(request: ListDataSourcesRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DataSourceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataSources(request))
  def listDataSourcesPaginated(request: ListDataSourcesRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListDataSourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataSourcesPaginated(request))
  def getEnvironmentProfile(request: GetEnvironmentProfileRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetEnvironmentProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEnvironmentProfile(request))
  def searchUserProfiles(request: SearchUserProfilesRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.UserProfileSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchUserProfiles(request))
  def searchUserProfilesPaginated(request: SearchUserProfilesRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.SearchUserProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchUserProfilesPaginated(request))
  def acceptPredictions(request: AcceptPredictionsRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.AcceptPredictionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptPredictions(request))
  def getListing(request: GetListingRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetListingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getListing(request))
  def getEnvironmentBlueprintConfiguration(
      request: GetEnvironmentBlueprintConfigurationRequest
  ): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetEnvironmentBlueprintConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEnvironmentBlueprintConfiguration(request))
  def updateEnvironmentProfile(request: UpdateEnvironmentProfileRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.UpdateEnvironmentProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEnvironmentProfile(request))
  def createDomain(request: CreateDomainRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDomain(request))
  def listAssetRevisions(request: ListAssetRevisionsRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.AssetRevision.ReadOnly
  ] = ZStream.serviceWithStream(_.listAssetRevisions(request))
  def listAssetRevisionsPaginated(request: ListAssetRevisionsRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListAssetRevisionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssetRevisionsPaginated(request))
  def deleteFormType(request: DeleteFormTypeRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DeleteFormTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFormType(request))
  def searchTypes(request: SearchTypesRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.SearchTypesResultItem.ReadOnly
  ] = ZStream.serviceWithStream(_.searchTypes(request))
  def searchTypesPaginated(request: SearchTypesRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.SearchTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchTypesPaginated(request))
  def getGlossary(request: GetGlossaryRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetGlossaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGlossary(request))
  def createAsset(request: CreateAssetRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateAssetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAsset(request))
  def listEnvironments(request: ListEnvironmentsRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.EnvironmentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEnvironments(request))
  def listEnvironmentsPaginated(request: ListEnvironmentsRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironmentsPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createProject(request: CreateProjectRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProject(request))
  def updateDomain(request: UpdateDomainRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.UpdateDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDomain(request))
  def updateDataSource(request: UpdateDataSourceRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.UpdateDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDataSource(request))
  def listEnvironmentBlueprintConfigurations(
      request: ListEnvironmentBlueprintConfigurationsRequest
  ): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem.ReadOnly
  ] =
    ZStream.serviceWithStream(_.listEnvironmentBlueprintConfigurations(request))
  def listEnvironmentBlueprintConfigurationsPaginated(
      request: ListEnvironmentBlueprintConfigurationsRequest
  ): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listEnvironmentBlueprintConfigurationsPaginated(request)
  )
  def deleteDataSource(request: DeleteDataSourceRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DeleteDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataSource(request))
  def getUserProfile(request: GetUserProfileRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetUserProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUserProfile(request))
  def getAsset(request: GetAssetRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetAssetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAsset(request))
  def getEnvironmentBlueprint(request: GetEnvironmentBlueprintRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetEnvironmentBlueprintResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEnvironmentBlueprint(request))
  def updateGlossaryTerm(request: UpdateGlossaryTermRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.UpdateGlossaryTermResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGlossaryTerm(request))
  def listSubscriptionGrants(request: ListSubscriptionGrantsRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.SubscriptionGrantSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSubscriptionGrants(request))
  def listSubscriptionGrantsPaginated(
      request: ListSubscriptionGrantsRequest
  ): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListSubscriptionGrantsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSubscriptionGrantsPaginated(request))
  def deleteAsset(request: DeleteAssetRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DeleteAssetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAsset(request))
  def getAssetType(request: GetAssetTypeRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GetAssetTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAssetType(request))
  def deleteProjectMembership(request: DeleteProjectMembershipRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DeleteProjectMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProjectMembership(request))
  def deleteSubscriptionRequest(
      request: DeleteSubscriptionRequestRequest
  ): ZIO[zio.aws.datazone.DataZone, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSubscriptionRequest(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def deleteDomain(request: DeleteDomainRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DeleteDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDomain(request))
  def acceptSubscriptionRequest(request: AcceptSubscriptionRequestRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.AcceptSubscriptionRequestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptSubscriptionRequest(request))
  def updateEnvironment(request: UpdateEnvironmentRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.UpdateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEnvironment(request))
  def rejectSubscriptionRequest(request: RejectSubscriptionRequestRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.RejectSubscriptionRequestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectSubscriptionRequest(request))
  def updateSubscriptionTarget(request: UpdateSubscriptionTargetRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.UpdateSubscriptionTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSubscriptionTarget(request))
  def search(request: SearchRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.SearchInventoryResultItem.ReadOnly
  ] = ZStream.serviceWithStream(_.search(request))
  def searchPaginated(request: SearchRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.SearchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchPaginated(request))
  def createSubscriptionRequest(request: CreateSubscriptionRequestRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateSubscriptionRequestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSubscriptionRequest(request))
  def cancelSubscription(request: CancelSubscriptionRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CancelSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelSubscription(request))
  def deleteEnvironmentProfile(
      request: DeleteEnvironmentProfileRequest
  ): ZIO[zio.aws.datazone.DataZone, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteEnvironmentProfile(request))
  def createGlossary(request: CreateGlossaryRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateGlossaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGlossary(request))
  def deleteProject(request: DeleteProjectRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DeleteProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProject(request))
  def deleteAssetType(request: DeleteAssetTypeRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DeleteAssetTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAssetType(request))
  def deleteListing(request: DeleteListingRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DeleteListingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteListing(request))
  def deleteGlossary(request: DeleteGlossaryRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.DeleteGlossaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGlossary(request))
  def createProjectMembership(request: CreateProjectMembershipRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateProjectMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProjectMembership(request))
  def createUserProfile(request: CreateUserProfileRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.CreateUserProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUserProfile(request))
  def searchGroupProfiles(request: SearchGroupProfilesRequest): ZStream[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.GroupProfileSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchGroupProfiles(request))
  def searchGroupProfilesPaginated(request: SearchGroupProfilesRequest): ZIO[
    zio.aws.datazone.DataZone,
    AwsError,
    zio.aws.datazone.model.SearchGroupProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchGroupProfilesPaginated(request))
}
