package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.ProjectId
import scala.jdk.CollectionConverters.*
final case class SubscribedProjectInput(
    identifier: Optional[ProjectId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SubscribedProjectInput = {
    import SubscribedProjectInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SubscribedProjectInput
      .builder()
      .optionallyWith(
        identifier.map(value => ProjectId.unwrap(value): java.lang.String)
      )(_.identifier)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SubscribedProjectInput.ReadOnly =
    zio.aws.datazone.model.SubscribedProjectInput.wrap(buildAwsValue())
}
object SubscribedProjectInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SubscribedProjectInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SubscribedProjectInput =
      zio.aws.datazone.model
        .SubscribedProjectInput(identifier.map(value => value))
    def identifier: Optional[ProjectId]
    def getIdentifier: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("identifier", identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedProjectInput
  ) extends zio.aws.datazone.model.SubscribedProjectInput.ReadOnly {
    override val identifier: Optional[ProjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.identifier())
      .map(value => zio.aws.datazone.model.primitives.ProjectId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedProjectInput
  ): zio.aws.datazone.model.SubscribedProjectInput.ReadOnly = new Wrapper(impl)
}
