package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{Integer, PaginationToken}
import scala.jdk.CollectionConverters.*
final case class SearchResponse(
    items: Optional[
      Iterable[zio.aws.datazone.model.SearchInventoryResultItem]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    totalMatchCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SearchResponse = {
    import SearchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SearchResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(totalMatchCount.map(value => value: java.lang.Integer))(
        _.totalMatchCount
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SearchResponse.ReadOnly =
    zio.aws.datazone.model.SearchResponse.wrap(buildAwsValue())
}
object SearchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SearchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SearchResponse =
      zio.aws.datazone.model.SearchResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        totalMatchCount.map(value => value)
      )
    def items: Optional[
      List[zio.aws.datazone.model.SearchInventoryResultItem.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def totalMatchCount: Optional[Integer]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.SearchInventoryResultItem.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTotalMatchCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalMatchCount", totalMatchCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SearchResponse
  ) extends zio.aws.datazone.model.SearchResponse.ReadOnly {
    override val items: Optional[
      List[zio.aws.datazone.model.SearchInventoryResultItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datazone.model.SearchInventoryResultItem.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val totalMatchCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalMatchCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SearchResponse
  ): zio.aws.datazone.model.SearchResponse.ReadOnly = new Wrapper(impl)
}
