package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  ProjectId,
  DomainId,
  PaginationToken,
  SearchText,
  MaxResults
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchRequest(
    additionalAttributes: Optional[
      Iterable[zio.aws.datazone.model.SearchOutputAdditionalAttribute]
    ] = Optional.Absent,
    domainIdentifier: DomainId,
    filters: Optional[zio.aws.datazone.model.FilterClause] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    owningProjectIdentifier: Optional[ProjectId] = Optional.Absent,
    searchIn: Optional[Iterable[zio.aws.datazone.model.SearchInItem]] =
      Optional.Absent,
    searchScope: zio.aws.datazone.model.InventorySearchScope,
    searchText: Optional[SearchText] = Optional.Absent,
    sort: Optional[zio.aws.datazone.model.SearchSort] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SearchRequest = {
    import SearchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SearchRequest
      .builder()
      .optionallyWith(
        additionalAttributes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.additionalAttributesWithStrings)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        owningProjectIdentifier.map(value =>
          ProjectId.unwrap(value): java.lang.String
        )
      )(_.owningProjectIdentifier)
      .optionallyWith(
        searchIn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.searchIn)
      .searchScope(searchScope.unwrap)
      .optionallyWith(
        searchText.map(value => SearchText.unwrap(value): java.lang.String)
      )(_.searchText)
      .optionallyWith(sort.map(value => value.buildAwsValue()))(_.sort)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SearchRequest.ReadOnly =
    zio.aws.datazone.model.SearchRequest.wrap(buildAwsValue())
}
object SearchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SearchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SearchRequest =
      zio.aws.datazone.model.SearchRequest(
        additionalAttributes.map(value => value),
        domainIdentifier,
        filters.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        owningProjectIdentifier.map(value => value),
        searchIn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        searchScope,
        searchText.map(value => value),
        sort.map(value => value.asEditable)
      )
    def additionalAttributes
        : Optional[List[zio.aws.datazone.model.SearchOutputAdditionalAttribute]]
    def domainIdentifier: DomainId
    def filters: Optional[zio.aws.datazone.model.FilterClause.ReadOnly]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def owningProjectIdentifier: Optional[ProjectId]
    def searchIn: Optional[List[zio.aws.datazone.model.SearchInItem.ReadOnly]]
    def searchScope: zio.aws.datazone.model.InventorySearchScope
    def searchText: Optional[SearchText]
    def sort: Optional[zio.aws.datazone.model.SearchSort.ReadOnly]
    def getAdditionalAttributes: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.SearchOutputAdditionalAttribute
    ]] =
      AwsError.unwrapOptionField("additionalAttributes", additionalAttributes)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getFilters
        : ZIO[Any, AwsError, zio.aws.datazone.model.FilterClause.ReadOnly] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOwningProjectIdentifier: ZIO[Any, AwsError, ProjectId] = AwsError
      .unwrapOptionField("owningProjectIdentifier", owningProjectIdentifier)
    def getSearchIn: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.SearchInItem.ReadOnly
    ]] = AwsError.unwrapOptionField("searchIn", searchIn)
    def getSearchScope
        : ZIO[Any, Nothing, zio.aws.datazone.model.InventorySearchScope] =
      ZIO.succeed(searchScope)
    def getSearchText: ZIO[Any, AwsError, SearchText] =
      AwsError.unwrapOptionField("searchText", searchText)
    def getSort
        : ZIO[Any, AwsError, zio.aws.datazone.model.SearchSort.ReadOnly] =
      AwsError.unwrapOptionField("sort", sort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SearchRequest
  ) extends zio.aws.datazone.model.SearchRequest.ReadOnly {
    override val additionalAttributes: Optional[
      List[zio.aws.datazone.model.SearchOutputAdditionalAttribute]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datazone.model.SearchOutputAdditionalAttribute.wrap(item)
        }.toList
      )
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val filters
        : Optional[zio.aws.datazone.model.FilterClause.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value => zio.aws.datazone.model.FilterClause.wrap(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val owningProjectIdentifier: Optional[ProjectId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owningProjectIdentifier())
        .map(value => zio.aws.datazone.model.primitives.ProjectId(value))
    override val searchIn
        : Optional[List[zio.aws.datazone.model.SearchInItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchIn())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.SearchInItem.wrap(item)
          }.toList
        )
    override val searchScope: zio.aws.datazone.model.InventorySearchScope =
      zio.aws.datazone.model.InventorySearchScope.wrap(impl.searchScope())
    override val searchText: Optional[SearchText] = zio.aws.core.internal
      .optionalFromNullable(impl.searchText())
      .map(value => zio.aws.datazone.model.primitives.SearchText(value))
    override val sort: Optional[zio.aws.datazone.model.SearchSort.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sort())
        .map(value => zio.aws.datazone.model.SearchSort.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SearchRequest
  ): zio.aws.datazone.model.SearchRequest.ReadOnly = new Wrapper(impl)
}
