package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.RedshiftClusterStorageClusterNameString
import scala.jdk.CollectionConverters.*
final case class RedshiftClusterStorage(
    clusterName: RedshiftClusterStorageClusterNameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RedshiftClusterStorage = {
    import RedshiftClusterStorage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RedshiftClusterStorage
      .builder()
      .clusterName(
        RedshiftClusterStorageClusterNameString.unwrap(
          clusterName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.RedshiftClusterStorage.ReadOnly =
    zio.aws.datazone.model.RedshiftClusterStorage.wrap(buildAwsValue())
}
object RedshiftClusterStorage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RedshiftClusterStorage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RedshiftClusterStorage =
      zio.aws.datazone.model.RedshiftClusterStorage(clusterName)
    def clusterName: RedshiftClusterStorageClusterNameString
    def getClusterName
        : ZIO[Any, Nothing, RedshiftClusterStorageClusterNameString] =
      ZIO.succeed(clusterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RedshiftClusterStorage
  ) extends zio.aws.datazone.model.RedshiftClusterStorage.ReadOnly {
    override val clusterName: RedshiftClusterStorageClusterNameString =
      zio.aws.datazone.model.primitives
        .RedshiftClusterStorageClusterNameString(impl.clusterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RedshiftClusterStorage
  ): zio.aws.datazone.model.RedshiftClusterStorage.ReadOnly = new Wrapper(impl)
}
