package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PredictionConfiguration(
    businessNameGeneration: Optional[
      zio.aws.datazone.model.BusinessNameGenerationConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.PredictionConfiguration = {
    import PredictionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.PredictionConfiguration
      .builder()
      .optionallyWith(
        businessNameGeneration.map(value => value.buildAwsValue())
      )(_.businessNameGeneration)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.PredictionConfiguration.ReadOnly =
    zio.aws.datazone.model.PredictionConfiguration.wrap(buildAwsValue())
}
object PredictionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.PredictionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.PredictionConfiguration =
      zio.aws.datazone.model.PredictionConfiguration(
        businessNameGeneration.map(value => value.asEditable)
      )
    def businessNameGeneration: Optional[
      zio.aws.datazone.model.BusinessNameGenerationConfiguration.ReadOnly
    ]
    def getBusinessNameGeneration: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.BusinessNameGenerationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "businessNameGeneration",
      businessNameGeneration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.PredictionConfiguration
  ) extends zio.aws.datazone.model.PredictionConfiguration.ReadOnly {
    override val businessNameGeneration: Optional[
      zio.aws.datazone.model.BusinessNameGenerationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.businessNameGeneration())
      .map(value =>
        zio.aws.datazone.model.BusinessNameGenerationConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.PredictionConfiguration
  ): zio.aws.datazone.model.PredictionConfiguration.ReadOnly = new Wrapper(impl)
}
