package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait NotificationType {
  def unwrap: software.amazon.awssdk.services.datazone.model.NotificationType
}
object NotificationType {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.NotificationType
  ): zio.aws.datazone.model.NotificationType = value match {
    case software.amazon.awssdk.services.datazone.model.NotificationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.NotificationType.TASK =>
      val r = TASK
      r
    case software.amazon.awssdk.services.datazone.model.NotificationType.EVENT =>
      val r = EVENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.NotificationType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.NotificationType =
      software.amazon.awssdk.services.datazone.model.NotificationType.UNKNOWN_TO_SDK_VERSION
  }
  case object TASK extends zio.aws.datazone.model.NotificationType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.NotificationType =
      software.amazon.awssdk.services.datazone.model.NotificationType.TASK
  }
  case object EVENT extends zio.aws.datazone.model.NotificationType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.NotificationType =
      software.amazon.awssdk.services.datazone.model.NotificationType.EVENT
  }
}
