package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{PaginationToken, MaxResults, DomainId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListEnvironmentBlueprintConfigurationsRequest(
    domainIdentifier: DomainId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest = {
    import ListEnvironmentBlueprintConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsRequest.ReadOnly =
    zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListEnvironmentBlueprintConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsRequest =
      zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsRequest(
        domainIdentifier,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def domainIdentifier: DomainId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest
  ) extends zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest
  ): zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
