package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait InventorySearchScope {
  def unwrap
      : software.amazon.awssdk.services.datazone.model.InventorySearchScope
}
object InventorySearchScope {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.InventorySearchScope
  ): zio.aws.datazone.model.InventorySearchScope = value match {
    case software.amazon.awssdk.services.datazone.model.InventorySearchScope.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.InventorySearchScope.ASSET =>
      val r = ASSET
      r
    case software.amazon.awssdk.services.datazone.model.InventorySearchScope.GLOSSARY =>
      val r = GLOSSARY
      r
    case software.amazon.awssdk.services.datazone.model.InventorySearchScope.GLOSSARY_TERM =>
      val r = GLOSSARY_TERM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.InventorySearchScope {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.InventorySearchScope =
      software.amazon.awssdk.services.datazone.model.InventorySearchScope.UNKNOWN_TO_SDK_VERSION
  }
  case object ASSET extends zio.aws.datazone.model.InventorySearchScope {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.InventorySearchScope =
      software.amazon.awssdk.services.datazone.model.InventorySearchScope.ASSET
  }
  case object GLOSSARY extends zio.aws.datazone.model.InventorySearchScope {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.InventorySearchScope =
      software.amazon.awssdk.services.datazone.model.InventorySearchScope.GLOSSARY
  }
  case object GLOSSARY_TERM
      extends zio.aws.datazone.model.InventorySearchScope {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.InventorySearchScope =
      software.amazon.awssdk.services.datazone.model.InventorySearchScope.GLOSSARY_TERM
  }
}
