package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait GroupSearchType {
  def unwrap: software.amazon.awssdk.services.datazone.model.GroupSearchType
}
object GroupSearchType {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.GroupSearchType
  ): zio.aws.datazone.model.GroupSearchType = value match {
    case software.amazon.awssdk.services.datazone.model.GroupSearchType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.GroupSearchType.SSO_GROUP =>
      val r = SSO_GROUP
      r
    case software.amazon.awssdk.services.datazone.model.GroupSearchType.DATAZONE_SSO_GROUP =>
      val r = DATAZONE_SSO_GROUP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.GroupSearchType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.GroupSearchType =
      software.amazon.awssdk.services.datazone.model.GroupSearchType.UNKNOWN_TO_SDK_VERSION
  }
  case object SSO_GROUP extends zio.aws.datazone.model.GroupSearchType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.GroupSearchType =
      software.amazon.awssdk.services.datazone.model.GroupSearchType.SSO_GROUP
  }
  case object DATAZONE_SSO_GROUP
      extends zio.aws.datazone.model.GroupSearchType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.GroupSearchType =
      software.amazon.awssdk.services.datazone.model.GroupSearchType.DATAZONE_SSO_GROUP
  }
}
