package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait GlossaryStatus {
  def unwrap: software.amazon.awssdk.services.datazone.model.GlossaryStatus
}
object GlossaryStatus {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.GlossaryStatus
  ): zio.aws.datazone.model.GlossaryStatus = value match {
    case software.amazon.awssdk.services.datazone.model.GlossaryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.GlossaryStatus.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.datazone.model.GlossaryStatus.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.GlossaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.GlossaryStatus =
      software.amazon.awssdk.services.datazone.model.GlossaryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.datazone.model.GlossaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.GlossaryStatus =
      software.amazon.awssdk.services.datazone.model.GlossaryStatus.DISABLED
  }
  case object ENABLED extends zio.aws.datazone.model.GlossaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.GlossaryStatus =
      software.amazon.awssdk.services.datazone.model.GlossaryStatus.ENABLED
  }
}
