package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{
  SubscriptionTargetId,
  EnvironmentId,
  DomainId
}
import scala.jdk.CollectionConverters.*
final case class GetSubscriptionTargetRequest(
    domainIdentifier: DomainId,
    environmentIdentifier: EnvironmentId,
    identifier: SubscriptionTargetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetSubscriptionTargetRequest = {
    import GetSubscriptionTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetSubscriptionTargetRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .identifier(SubscriptionTargetId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetSubscriptionTargetRequest.ReadOnly =
    zio.aws.datazone.model.GetSubscriptionTargetRequest.wrap(buildAwsValue())
}
object GetSubscriptionTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetSubscriptionTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetSubscriptionTargetRequest =
      zio.aws.datazone.model.GetSubscriptionTargetRequest(
        domainIdentifier,
        environmentIdentifier,
        identifier
      )
    def domainIdentifier: DomainId
    def environmentIdentifier: EnvironmentId
    def identifier: SubscriptionTargetId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
    def getIdentifier: ZIO[Any, Nothing, SubscriptionTargetId] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetSubscriptionTargetRequest
  ) extends zio.aws.datazone.model.GetSubscriptionTargetRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val environmentIdentifier: EnvironmentId =
      zio.aws.datazone.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
    override val identifier: SubscriptionTargetId =
      zio.aws.datazone.model.primitives.SubscriptionTargetId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetSubscriptionTargetRequest
  ): zio.aws.datazone.model.GetSubscriptionTargetRequest.ReadOnly = new Wrapper(
    impl
  )
}
