package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{SubscriptionRequestId, DomainId}
import scala.jdk.CollectionConverters.*
final case class GetSubscriptionRequestDetailsRequest(
    domainIdentifier: DomainId,
    identifier: SubscriptionRequestId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetSubscriptionRequestDetailsRequest = {
    import GetSubscriptionRequestDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetSubscriptionRequestDetailsRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(SubscriptionRequestId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.GetSubscriptionRequestDetailsRequest.ReadOnly =
    zio.aws.datazone.model.GetSubscriptionRequestDetailsRequest
      .wrap(buildAwsValue())
}
object GetSubscriptionRequestDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetSubscriptionRequestDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datazone.model.GetSubscriptionRequestDetailsRequest =
      zio.aws.datazone.model
        .GetSubscriptionRequestDetailsRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: SubscriptionRequestId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, SubscriptionRequestId] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetSubscriptionRequestDetailsRequest
  ) extends zio.aws.datazone.model.GetSubscriptionRequestDetailsRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: SubscriptionRequestId =
      zio.aws.datazone.model.primitives.SubscriptionRequestId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetSubscriptionRequestDetailsRequest
  ): zio.aws.datazone.model.GetSubscriptionRequestDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
