package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{EnvironmentId, DomainId}
import scala.jdk.CollectionConverters.*
final case class GetEnvironmentRequest(
    domainIdentifier: DomainId,
    identifier: EnvironmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetEnvironmentRequest = {
    import GetEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetEnvironmentRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(EnvironmentId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetEnvironmentRequest.ReadOnly =
    zio.aws.datazone.model.GetEnvironmentRequest.wrap(buildAwsValue())
}
object GetEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetEnvironmentRequest =
      zio.aws.datazone.model.GetEnvironmentRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: EnvironmentId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetEnvironmentRequest
  ) extends zio.aws.datazone.model.GetEnvironmentRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: EnvironmentId =
      zio.aws.datazone.model.primitives.EnvironmentId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetEnvironmentRequest
  ): zio.aws.datazone.model.GetEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
