package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  GlossaryTermId,
  SyntheticTimestamp_date_time,
  EnvironmentBlueprintName,
  Description,
  EnvironmentBlueprintId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetEnvironmentBlueprintResponse(
    createdAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    deploymentProperties: Optional[
      zio.aws.datazone.model.DeploymentProperties
    ] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    glossaryTerms: Optional[Iterable[GlossaryTermId]] = Optional.Absent,
    id: EnvironmentBlueprintId,
    name: EnvironmentBlueprintName,
    provider: String,
    provisioningProperties: zio.aws.datazone.model.ProvisioningProperties,
    updatedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    userParameters: Optional[Iterable[zio.aws.datazone.model.CustomParameter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintResponse = {
    import GetEnvironmentBlueprintResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintResponse
      .builder()
      .optionallyWith(
        createdAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAt)
      .optionallyWith(deploymentProperties.map(value => value.buildAwsValue()))(
        _.deploymentProperties
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        glossaryTerms.map(value =>
          value.map { item =>
            GlossaryTermId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.glossaryTerms)
      .id(EnvironmentBlueprintId.unwrap(id): java.lang.String)
      .name(EnvironmentBlueprintName.unwrap(name): java.lang.String)
      .provider(provider: java.lang.String)
      .provisioningProperties(provisioningProperties.buildAwsValue())
      .optionallyWith(
        updatedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.updatedAt)
      .optionallyWith(
        userParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userParameters)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.GetEnvironmentBlueprintResponse.ReadOnly =
    zio.aws.datazone.model.GetEnvironmentBlueprintResponse.wrap(buildAwsValue())
}
object GetEnvironmentBlueprintResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetEnvironmentBlueprintResponse =
      zio.aws.datazone.model.GetEnvironmentBlueprintResponse(
        createdAt.map(value => value),
        deploymentProperties.map(value => value.asEditable),
        description.map(value => value),
        glossaryTerms.map(value => value),
        id,
        name,
        provider,
        provisioningProperties.asEditable,
        updatedAt.map(value => value),
        userParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def createdAt: Optional[SyntheticTimestamp_date_time]
    def deploymentProperties
        : Optional[zio.aws.datazone.model.DeploymentProperties.ReadOnly]
    def description: Optional[Description]
    def glossaryTerms: Optional[List[GlossaryTermId]]
    def id: EnvironmentBlueprintId
    def name: EnvironmentBlueprintName
    def provider: String
    def provisioningProperties
        : zio.aws.datazone.model.ProvisioningProperties.ReadOnly
    def updatedAt: Optional[SyntheticTimestamp_date_time]
    def userParameters
        : Optional[List[zio.aws.datazone.model.CustomParameter.ReadOnly]]
    def getCreatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDeploymentProperties: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.DeploymentProperties.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentProperties", deploymentProperties)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getGlossaryTerms: ZIO[Any, AwsError, List[GlossaryTermId]] =
      AwsError.unwrapOptionField("glossaryTerms", glossaryTerms)
    def getId: ZIO[Any, Nothing, EnvironmentBlueprintId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, EnvironmentBlueprintName] = ZIO.succeed(name)
    def getProvider: ZIO[Any, Nothing, String] = ZIO.succeed(provider)
    def getProvisioningProperties: ZIO[
      Any,
      Nothing,
      zio.aws.datazone.model.ProvisioningProperties.ReadOnly
    ] = ZIO.succeed(provisioningProperties)
    def getUpdatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUserParameters: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.CustomParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("userParameters", userParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintResponse
  ) extends zio.aws.datazone.model.GetEnvironmentBlueprintResponse.ReadOnly {
    override val createdAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val deploymentProperties
        : Optional[zio.aws.datazone.model.DeploymentProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentProperties())
        .map(value => zio.aws.datazone.model.DeploymentProperties.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val glossaryTerms: Optional[List[GlossaryTermId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTerms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.GlossaryTermId(item)
          }.toList
        )
    override val id: EnvironmentBlueprintId =
      zio.aws.datazone.model.primitives.EnvironmentBlueprintId(impl.id())
    override val name: EnvironmentBlueprintName =
      zio.aws.datazone.model.primitives.EnvironmentBlueprintName(impl.name())
    override val provider: String = impl.provider(): String
    override val provisioningProperties
        : zio.aws.datazone.model.ProvisioningProperties.ReadOnly =
      zio.aws.datazone.model.ProvisioningProperties
        .wrap(impl.provisioningProperties())
    override val updatedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val userParameters
        : Optional[List[zio.aws.datazone.model.CustomParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.CustomParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintResponse
  ): zio.aws.datazone.model.GetEnvironmentBlueprintResponse.ReadOnly =
    new Wrapper(impl)
}
