package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  RoleArn,
  CreatedAt,
  TagValue,
  DomainId,
  UpdatedAt,
  KmsKeyArn,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetDomainResponse(
    arn: Optional[String] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    domainExecutionRole: RoleArn,
    id: DomainId,
    kmsKeyIdentifier: Optional[KmsKeyArn] = Optional.Absent,
    lastUpdatedAt: Optional[UpdatedAt] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    portalUrl: Optional[String] = Optional.Absent,
    singleSignOn: Optional[zio.aws.datazone.model.SingleSignOn] =
      Optional.Absent,
    status: zio.aws.datazone.model.DomainStatus,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetDomainResponse = {
    import GetDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetDomainResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .domainExecutionRole(
        RoleArn.unwrap(domainExecutionRole): java.lang.String
      )
      .id(DomainId.unwrap(id): java.lang.String)
      .optionallyWith(
        kmsKeyIdentifier.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyIdentifier)
      .optionallyWith(
        lastUpdatedAt.map(value => UpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(portalUrl.map(value => value: java.lang.String))(
        _.portalUrl
      )
      .optionallyWith(singleSignOn.map(value => value.buildAwsValue()))(
        _.singleSignOn
      )
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetDomainResponse.ReadOnly =
    zio.aws.datazone.model.GetDomainResponse.wrap(buildAwsValue())
}
object GetDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetDomainResponse =
      zio.aws.datazone.model.GetDomainResponse(
        arn.map(value => value),
        createdAt.map(value => value),
        description.map(value => value),
        domainExecutionRole,
        id,
        kmsKeyIdentifier.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        portalUrl.map(value => value),
        singleSignOn.map(value => value.asEditable),
        status,
        tags.map(value => value)
      )
    def arn: Optional[String]
    def createdAt: Optional[CreatedAt]
    def description: Optional[String]
    def domainExecutionRole: RoleArn
    def id: DomainId
    def kmsKeyIdentifier: Optional[KmsKeyArn]
    def lastUpdatedAt: Optional[UpdatedAt]
    def name: Optional[String]
    def portalUrl: Optional[String]
    def singleSignOn: Optional[zio.aws.datazone.model.SingleSignOn.ReadOnly]
    def status: zio.aws.datazone.model.DomainStatus
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDomainExecutionRole: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(domainExecutionRole)
    def getId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(id)
    def getKmsKeyIdentifier: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyIdentifier", kmsKeyIdentifier)
    def getLastUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getPortalUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("portalUrl", portalUrl)
    def getSingleSignOn
        : ZIO[Any, AwsError, zio.aws.datazone.model.SingleSignOn.ReadOnly] =
      AwsError.unwrapOptionField("singleSignOn", singleSignOn)
    def getStatus: ZIO[Any, Nothing, zio.aws.datazone.model.DomainStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetDomainResponse
  ) extends zio.aws.datazone.model.GetDomainResponse.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.datazone.model.primitives.CreatedAt(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val domainExecutionRole: RoleArn =
      zio.aws.datazone.model.primitives.RoleArn(impl.domainExecutionRole())
    override val id: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.id())
    override val kmsKeyIdentifier: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyIdentifier())
      .map(value => zio.aws.datazone.model.primitives.KmsKeyArn(value))
    override val lastUpdatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.datazone.model.primitives.UpdatedAt(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val portalUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.portalUrl())
      .map(value => value: String)
    override val singleSignOn
        : Optional[zio.aws.datazone.model.SingleSignOn.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.singleSignOn())
        .map(value => zio.aws.datazone.model.SingleSignOn.wrap(value))
    override val status: zio.aws.datazone.model.DomainStatus =
      zio.aws.datazone.model.DomainStatus.wrap(impl.status())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.datazone.model.primitives
              .TagKey(key) -> zio.aws.datazone.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetDomainResponse
  ): zio.aws.datazone.model.GetDomainResponse.ReadOnly = new Wrapper(impl)
}
