package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EnvironmentError(
    code: Optional[String] = Optional.Absent,
    message: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.EnvironmentError = {
    import EnvironmentError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.EnvironmentError
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .message(message: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.EnvironmentError.ReadOnly =
    zio.aws.datazone.model.EnvironmentError.wrap(buildAwsValue())
}
object EnvironmentError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.EnvironmentError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.EnvironmentError =
      zio.aws.datazone.model.EnvironmentError(code.map(value => value), message)
    def code: Optional[String]
    def message: String
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, Nothing, String] = ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.EnvironmentError
  ) extends zio.aws.datazone.model.EnvironmentError.ReadOnly {
    override val code: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: String)
    override val message: String = impl.message(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.EnvironmentError
  ): zio.aws.datazone.model.EnvironmentError.ReadOnly = new Wrapper(impl)
}
