package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{SubscriptionRequestId, DomainId}
import scala.jdk.CollectionConverters.*
final case class DeleteSubscriptionRequestRequest(
    domainIdentifier: DomainId,
    identifier: SubscriptionRequestId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DeleteSubscriptionRequestRequest = {
    import DeleteSubscriptionRequestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DeleteSubscriptionRequestRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(SubscriptionRequestId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.DeleteSubscriptionRequestRequest.ReadOnly =
    zio.aws.datazone.model.DeleteSubscriptionRequestRequest
      .wrap(buildAwsValue())
}
object DeleteSubscriptionRequestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DeleteSubscriptionRequestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DeleteSubscriptionRequestRequest =
      zio.aws.datazone.model
        .DeleteSubscriptionRequestRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: SubscriptionRequestId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, SubscriptionRequestId] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DeleteSubscriptionRequestRequest
  ) extends zio.aws.datazone.model.DeleteSubscriptionRequestRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: SubscriptionRequestId =
      zio.aws.datazone.model.primitives.SubscriptionRequestId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DeleteSubscriptionRequestRequest
  ): zio.aws.datazone.model.DeleteSubscriptionRequestRequest.ReadOnly =
    new Wrapper(impl)
}
