package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{GlossaryId, DomainId}
import scala.jdk.CollectionConverters.*
final case class DeleteGlossaryRequest(
    domainIdentifier: DomainId,
    identifier: GlossaryId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DeleteGlossaryRequest = {
    import DeleteGlossaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DeleteGlossaryRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(GlossaryId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DeleteGlossaryRequest.ReadOnly =
    zio.aws.datazone.model.DeleteGlossaryRequest.wrap(buildAwsValue())
}
object DeleteGlossaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DeleteGlossaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DeleteGlossaryRequest =
      zio.aws.datazone.model.DeleteGlossaryRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: GlossaryId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, GlossaryId] = ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DeleteGlossaryRequest
  ) extends zio.aws.datazone.model.DeleteGlossaryRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: GlossaryId =
      zio.aws.datazone.model.primitives.GlossaryId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DeleteGlossaryRequest
  ): zio.aws.datazone.model.DeleteGlossaryRequest.ReadOnly = new Wrapper(impl)
}
