package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{FormTypeIdentifier, DomainId}
import scala.jdk.CollectionConverters.*
final case class DeleteFormTypeRequest(
    domainIdentifier: DomainId,
    formTypeIdentifier: FormTypeIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DeleteFormTypeRequest = {
    import DeleteFormTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DeleteFormTypeRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .formTypeIdentifier(
        FormTypeIdentifier.unwrap(formTypeIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DeleteFormTypeRequest.ReadOnly =
    zio.aws.datazone.model.DeleteFormTypeRequest.wrap(buildAwsValue())
}
object DeleteFormTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DeleteFormTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DeleteFormTypeRequest =
      zio.aws.datazone.model
        .DeleteFormTypeRequest(domainIdentifier, formTypeIdentifier)
    def domainIdentifier: DomainId
    def formTypeIdentifier: FormTypeIdentifier
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getFormTypeIdentifier: ZIO[Any, Nothing, FormTypeIdentifier] =
      ZIO.succeed(formTypeIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DeleteFormTypeRequest
  ) extends zio.aws.datazone.model.DeleteFormTypeRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val formTypeIdentifier: FormTypeIdentifier =
      zio.aws.datazone.model.primitives
        .FormTypeIdentifier(impl.formTypeIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DeleteFormTypeRequest
  ): zio.aws.datazone.model.DeleteFormTypeRequest.ReadOnly = new Wrapper(impl)
}
