package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait DataSourceRunStatus {
  def unwrap: software.amazon.awssdk.services.datazone.model.DataSourceRunStatus
}
object DataSourceRunStatus {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.DataSourceRunStatus
  ): zio.aws.datazone.model.DataSourceRunStatus = value match {
    case software.amazon.awssdk.services.datazone.model.DataSourceRunStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceRunStatus.REQUESTED =>
      val r = REQUESTED
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceRunStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceRunStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceRunStatus.PARTIALLY_SUCCEEDED =>
      val r = PARTIALLY_SUCCEEDED
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceRunStatus.SUCCESS =>
      val r = SUCCESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.DataSourceRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceRunStatus =
      software.amazon.awssdk.services.datazone.model.DataSourceRunStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object REQUESTED extends zio.aws.datazone.model.DataSourceRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceRunStatus =
      software.amazon.awssdk.services.datazone.model.DataSourceRunStatus.REQUESTED
  }
  case object RUNNING extends zio.aws.datazone.model.DataSourceRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceRunStatus =
      software.amazon.awssdk.services.datazone.model.DataSourceRunStatus.RUNNING
  }
  case object FAILED extends zio.aws.datazone.model.DataSourceRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceRunStatus =
      software.amazon.awssdk.services.datazone.model.DataSourceRunStatus.FAILED
  }
  case object PARTIALLY_SUCCEEDED
      extends zio.aws.datazone.model.DataSourceRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceRunStatus =
      software.amazon.awssdk.services.datazone.model.DataSourceRunStatus.PARTIALLY_SUCCEEDED
  }
  case object SUCCESS extends zio.aws.datazone.model.DataSourceRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceRunStatus =
      software.amazon.awssdk.services.datazone.model.DataSourceRunStatus.SUCCESS
  }
}
