package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  ProjectId,
  DataSourceRunId,
  DateTime,
  Description,
  Name
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DataSourceRunActivity(
    createdAt: DateTime,
    dataAssetId: Optional[String] = Optional.Absent,
    dataAssetStatus: zio.aws.datazone.model.DataAssetActivityStatus,
    dataSourceRunId: DataSourceRunId,
    database: Name,
    errorMessage: Optional[zio.aws.datazone.model.DataSourceErrorMessage] =
      Optional.Absent,
    projectId: ProjectId,
    technicalDescription: Optional[Description] = Optional.Absent,
    technicalName: Name,
    updatedAt: DateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DataSourceRunActivity = {
    import DataSourceRunActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DataSourceRunActivity
      .builder()
      .createdAt(DateTime.unwrap(createdAt): Instant)
      .optionallyWith(dataAssetId.map(value => value: java.lang.String))(
        _.dataAssetId
      )
      .dataAssetStatus(dataAssetStatus.unwrap)
      .dataSourceRunId(
        DataSourceRunId.unwrap(dataSourceRunId): java.lang.String
      )
      .database(Name.unwrap(database): java.lang.String)
      .optionallyWith(errorMessage.map(value => value.buildAwsValue()))(
        _.errorMessage
      )
      .projectId(ProjectId.unwrap(projectId): java.lang.String)
      .optionallyWith(
        technicalDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.technicalDescription)
      .technicalName(Name.unwrap(technicalName): java.lang.String)
      .updatedAt(DateTime.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DataSourceRunActivity.ReadOnly =
    zio.aws.datazone.model.DataSourceRunActivity.wrap(buildAwsValue())
}
object DataSourceRunActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DataSourceRunActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DataSourceRunActivity =
      zio.aws.datazone.model.DataSourceRunActivity(
        createdAt,
        dataAssetId.map(value => value),
        dataAssetStatus,
        dataSourceRunId,
        database,
        errorMessage.map(value => value.asEditable),
        projectId,
        technicalDescription.map(value => value),
        technicalName,
        updatedAt
      )
    def createdAt: DateTime
    def dataAssetId: Optional[String]
    def dataAssetStatus: zio.aws.datazone.model.DataAssetActivityStatus
    def dataSourceRunId: DataSourceRunId
    def database: Name
    def errorMessage
        : Optional[zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly]
    def projectId: ProjectId
    def technicalDescription: Optional[Description]
    def technicalName: Name
    def updatedAt: DateTime
    def getCreatedAt: ZIO[Any, Nothing, DateTime] = ZIO.succeed(createdAt)
    def getDataAssetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataAssetId", dataAssetId)
    def getDataAssetStatus
        : ZIO[Any, Nothing, zio.aws.datazone.model.DataAssetActivityStatus] =
      ZIO.succeed(dataAssetStatus)
    def getDataSourceRunId: ZIO[Any, Nothing, DataSourceRunId] =
      ZIO.succeed(dataSourceRunId)
    def getDatabase: ZIO[Any, Nothing, Name] = ZIO.succeed(database)
    def getErrorMessage: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly
    ] = AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getProjectId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(projectId)
    def getTechnicalDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("technicalDescription", technicalDescription)
    def getTechnicalName: ZIO[Any, Nothing, Name] = ZIO.succeed(technicalName)
    def getUpdatedAt: ZIO[Any, Nothing, DateTime] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DataSourceRunActivity
  ) extends zio.aws.datazone.model.DataSourceRunActivity.ReadOnly {
    override val createdAt: DateTime =
      zio.aws.datazone.model.primitives.DateTime(impl.createdAt())
    override val dataAssetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataAssetId())
      .map(value => value: String)
    override val dataAssetStatus
        : zio.aws.datazone.model.DataAssetActivityStatus =
      zio.aws.datazone.model.DataAssetActivityStatus
        .wrap(impl.dataAssetStatus())
    override val dataSourceRunId: DataSourceRunId =
      zio.aws.datazone.model.primitives.DataSourceRunId(impl.dataSourceRunId())
    override val database: Name =
      zio.aws.datazone.model.primitives.Name(impl.database())
    override val errorMessage
        : Optional[zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorMessage())
        .map(value => zio.aws.datazone.model.DataSourceErrorMessage.wrap(value))
    override val projectId: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.projectId())
    override val technicalDescription: Optional[Description] =
      zio.aws.core.internal
        .optionalFromNullable(impl.technicalDescription())
        .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val technicalName: Name =
      zio.aws.datazone.model.primitives.Name(impl.technicalName())
    override val updatedAt: DateTime =
      zio.aws.datazone.model.primitives.DateTime(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DataSourceRunActivity
  ): zio.aws.datazone.model.DataSourceRunActivity.ReadOnly = new Wrapper(impl)
}
