package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait DataSourceErrorType {
  def unwrap: software.amazon.awssdk.services.datazone.model.DataSourceErrorType
}
object DataSourceErrorType {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.DataSourceErrorType
  ): zio.aws.datazone.model.DataSourceErrorType = value match {
    case software.amazon.awssdk.services.datazone.model.DataSourceErrorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceErrorType.ACCESS_DENIED_EXCEPTION =>
      val r = ACCESS_DENIED_EXCEPTION
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceErrorType.CONFLICT_EXCEPTION =>
      val r = CONFLICT_EXCEPTION
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceErrorType.INTERNAL_SERVER_EXCEPTION =>
      val r = INTERNAL_SERVER_EXCEPTION
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceErrorType.RESOURCE_NOT_FOUND_EXCEPTION =>
      val r = RESOURCE_NOT_FOUND_EXCEPTION
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceErrorType.SERVICE_QUOTA_EXCEEDED_EXCEPTION =>
      val r = SERVICE_QUOTA_EXCEEDED_EXCEPTION
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceErrorType.THROTTLING_EXCEPTION =>
      val r = THROTTLING_EXCEPTION
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceErrorType.VALIDATION_EXCEPTION =>
      val r = VALIDATION_EXCEPTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.DataSourceErrorType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceErrorType =
      software.amazon.awssdk.services.datazone.model.DataSourceErrorType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCESS_DENIED_EXCEPTION
      extends zio.aws.datazone.model.DataSourceErrorType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceErrorType =
      software.amazon.awssdk.services.datazone.model.DataSourceErrorType.ACCESS_DENIED_EXCEPTION
  }
  case object CONFLICT_EXCEPTION
      extends zio.aws.datazone.model.DataSourceErrorType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceErrorType =
      software.amazon.awssdk.services.datazone.model.DataSourceErrorType.CONFLICT_EXCEPTION
  }
  case object INTERNAL_SERVER_EXCEPTION
      extends zio.aws.datazone.model.DataSourceErrorType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceErrorType =
      software.amazon.awssdk.services.datazone.model.DataSourceErrorType.INTERNAL_SERVER_EXCEPTION
  }
  case object RESOURCE_NOT_FOUND_EXCEPTION
      extends zio.aws.datazone.model.DataSourceErrorType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceErrorType =
      software.amazon.awssdk.services.datazone.model.DataSourceErrorType.RESOURCE_NOT_FOUND_EXCEPTION
  }
  case object SERVICE_QUOTA_EXCEEDED_EXCEPTION
      extends zio.aws.datazone.model.DataSourceErrorType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceErrorType =
      software.amazon.awssdk.services.datazone.model.DataSourceErrorType.SERVICE_QUOTA_EXCEEDED_EXCEPTION
  }
  case object THROTTLING_EXCEPTION
      extends zio.aws.datazone.model.DataSourceErrorType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceErrorType =
      software.amazon.awssdk.services.datazone.model.DataSourceErrorType.THROTTLING_EXCEPTION
  }
  case object VALIDATION_EXCEPTION
      extends zio.aws.datazone.model.DataSourceErrorType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceErrorType =
      software.amazon.awssdk.services.datazone.model.DataSourceErrorType.VALIDATION_EXCEPTION
  }
}
