package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{DataProductId, DomainId}
import scala.jdk.CollectionConverters.*
final case class DataProductItem(
    domainId: Optional[DomainId] = Optional.Absent,
    itemId: Optional[DataProductId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DataProductItem = {
    import DataProductItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DataProductItem
      .builder()
      .optionallyWith(
        domainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        itemId.map(value => DataProductId.unwrap(value): java.lang.String)
      )(_.itemId)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DataProductItem.ReadOnly =
    zio.aws.datazone.model.DataProductItem.wrap(buildAwsValue())
}
object DataProductItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DataProductItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DataProductItem =
      zio.aws.datazone.model.DataProductItem(
        domainId.map(value => value),
        itemId.map(value => value)
      )
    def domainId: Optional[DomainId]
    def itemId: Optional[DataProductId]
    def getDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getItemId: ZIO[Any, AwsError, DataProductId] =
      AwsError.unwrapOptionField("itemId", itemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DataProductItem
  ) extends zio.aws.datazone.model.DataProductItem.ReadOnly {
    override val domainId: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainId())
      .map(value => zio.aws.datazone.model.primitives.DomainId(value))
    override val itemId: Optional[DataProductId] = zio.aws.core.internal
      .optionalFromNullable(impl.itemId())
      .map(value => zio.aws.datazone.model.primitives.DataProductId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DataProductItem
  ): zio.aws.datazone.model.DataProductItem.ReadOnly = new Wrapper(impl)
}
