package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  UpdatedBy,
  ProjectId,
  CreatedAt,
  DomainId,
  EnvironmentId,
  CreatedBy,
  TypeName,
  AuthorizedPrincipalIdentifier,
  SubscriptionTargetId,
  UpdatedAt,
  SubscriptionTargetName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateSubscriptionTargetResponse(
    applicableAssetTypes: Iterable[TypeName],
    authorizedPrincipals: Iterable[AuthorizedPrincipalIdentifier],
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    domainId: DomainId,
    environmentId: EnvironmentId,
    id: SubscriptionTargetId,
    manageAccessRole: String,
    name: SubscriptionTargetName,
    projectId: ProjectId,
    provider: String,
    subscriptionTargetConfig: Iterable[
      zio.aws.datazone.model.SubscriptionTargetForm
    ],
    `type`: String,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetResponse = {
    import CreateSubscriptionTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetResponse
      .builder()
      .applicableAssetTypes(applicableAssetTypes.map { item =>
        TypeName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .authorizedPrincipals(authorizedPrincipals.map { item =>
        AuthorizedPrincipalIdentifier.unwrap(item): java.lang.String
      }.asJavaCollection)
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .id(SubscriptionTargetId.unwrap(id): java.lang.String)
      .manageAccessRole(manageAccessRole: java.lang.String)
      .name(SubscriptionTargetName.unwrap(name): java.lang.String)
      .projectId(ProjectId.unwrap(projectId): java.lang.String)
      .provider(provider: java.lang.String)
      .subscriptionTargetConfig(subscriptionTargetConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .`type`(`type`: java.lang.String)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.CreateSubscriptionTargetResponse.ReadOnly =
    zio.aws.datazone.model.CreateSubscriptionTargetResponse
      .wrap(buildAwsValue())
}
object CreateSubscriptionTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateSubscriptionTargetResponse =
      zio.aws.datazone.model.CreateSubscriptionTargetResponse(
        applicableAssetTypes,
        authorizedPrincipals,
        createdAt,
        createdBy,
        domainId,
        environmentId,
        id,
        manageAccessRole,
        name,
        projectId,
        provider,
        subscriptionTargetConfig.map { item =>
          item.asEditable
        },
        `type`,
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def applicableAssetTypes: List[TypeName]
    def authorizedPrincipals: List[AuthorizedPrincipalIdentifier]
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def domainId: DomainId
    def environmentId: EnvironmentId
    def id: SubscriptionTargetId
    def manageAccessRole: String
    def name: SubscriptionTargetName
    def projectId: ProjectId
    def provider: String
    def subscriptionTargetConfig
        : List[zio.aws.datazone.model.SubscriptionTargetForm.ReadOnly]
    def `type`: String
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def getApplicableAssetTypes: ZIO[Any, Nothing, List[TypeName]] =
      ZIO.succeed(applicableAssetTypes)
    def getAuthorizedPrincipals
        : ZIO[Any, Nothing, List[AuthorizedPrincipalIdentifier]] =
      ZIO.succeed(authorizedPrincipals)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getId: ZIO[Any, Nothing, SubscriptionTargetId] = ZIO.succeed(id)
    def getManageAccessRole: ZIO[Any, Nothing, String] =
      ZIO.succeed(manageAccessRole)
    def getName: ZIO[Any, Nothing, SubscriptionTargetName] = ZIO.succeed(name)
    def getProjectId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(projectId)
    def getProvider: ZIO[Any, Nothing, String] = ZIO.succeed(provider)
    def getSubscriptionTargetConfig: ZIO[Any, Nothing, List[
      zio.aws.datazone.model.SubscriptionTargetForm.ReadOnly
    ]] = ZIO.succeed(subscriptionTargetConfig)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetResponse
  ) extends zio.aws.datazone.model.CreateSubscriptionTargetResponse.ReadOnly {
    override val applicableAssetTypes: List[TypeName] = impl
      .applicableAssetTypes()
      .asScala
      .map { item =>
        zio.aws.datazone.model.primitives.TypeName(item)
      }
      .toList
    override val authorizedPrincipals: List[AuthorizedPrincipalIdentifier] =
      impl
        .authorizedPrincipals()
        .asScala
        .map { item =>
          zio.aws.datazone.model.primitives.AuthorizedPrincipalIdentifier(item)
        }
        .toList
    override val createdAt: CreatedAt =
      zio.aws.datazone.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.datazone.model.primitives.CreatedBy(impl.createdBy())
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val environmentId: EnvironmentId =
      zio.aws.datazone.model.primitives.EnvironmentId(impl.environmentId())
    override val id: SubscriptionTargetId =
      zio.aws.datazone.model.primitives.SubscriptionTargetId(impl.id())
    override val manageAccessRole: String = impl.manageAccessRole(): String
    override val name: SubscriptionTargetName =
      zio.aws.datazone.model.primitives.SubscriptionTargetName(impl.name())
    override val projectId: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.projectId())
    override val provider: String = impl.provider(): String
    override val subscriptionTargetConfig
        : List[zio.aws.datazone.model.SubscriptionTargetForm.ReadOnly] = impl
      .subscriptionTargetConfig()
      .asScala
      .map { item =>
        zio.aws.datazone.model.SubscriptionTargetForm.wrap(item)
      }
      .toList
    override val `type`: String = impl.`type`(): String
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.datazone.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.datazone.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetResponse
  ): zio.aws.datazone.model.CreateSubscriptionTargetResponse.ReadOnly =
    new Wrapper(impl)
}
