package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  DomainId,
  EnvironmentId,
  TypeName,
  AuthorizedPrincipalIdentifier,
  SubscriptionTargetName
}
import scala.jdk.CollectionConverters.*
final case class CreateSubscriptionTargetRequest(
    applicableAssetTypes: Iterable[TypeName],
    authorizedPrincipals: Iterable[AuthorizedPrincipalIdentifier],
    clientToken: Optional[String] = Optional.Absent,
    domainIdentifier: DomainId,
    environmentIdentifier: EnvironmentId,
    manageAccessRole: String,
    name: SubscriptionTargetName,
    provider: Optional[String] = Optional.Absent,
    subscriptionTargetConfig: Iterable[
      zio.aws.datazone.model.SubscriptionTargetForm
    ],
    `type`: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetRequest = {
    import CreateSubscriptionTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetRequest
      .builder()
      .applicableAssetTypes(applicableAssetTypes.map { item =>
        TypeName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .authorizedPrincipals(authorizedPrincipals.map { item =>
        AuthorizedPrincipalIdentifier.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .manageAccessRole(manageAccessRole: java.lang.String)
      .name(SubscriptionTargetName.unwrap(name): java.lang.String)
      .optionallyWith(provider.map(value => value: java.lang.String))(
        _.provider
      )
      .subscriptionTargetConfig(subscriptionTargetConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .`type`(`type`: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.CreateSubscriptionTargetRequest.ReadOnly =
    zio.aws.datazone.model.CreateSubscriptionTargetRequest.wrap(buildAwsValue())
}
object CreateSubscriptionTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateSubscriptionTargetRequest =
      zio.aws.datazone.model.CreateSubscriptionTargetRequest(
        applicableAssetTypes,
        authorizedPrincipals,
        clientToken.map(value => value),
        domainIdentifier,
        environmentIdentifier,
        manageAccessRole,
        name,
        provider.map(value => value),
        subscriptionTargetConfig.map { item =>
          item.asEditable
        },
        `type`
      )
    def applicableAssetTypes: List[TypeName]
    def authorizedPrincipals: List[AuthorizedPrincipalIdentifier]
    def clientToken: Optional[String]
    def domainIdentifier: DomainId
    def environmentIdentifier: EnvironmentId
    def manageAccessRole: String
    def name: SubscriptionTargetName
    def provider: Optional[String]
    def subscriptionTargetConfig
        : List[zio.aws.datazone.model.SubscriptionTargetForm.ReadOnly]
    def `type`: String
    def getApplicableAssetTypes: ZIO[Any, Nothing, List[TypeName]] =
      ZIO.succeed(applicableAssetTypes)
    def getAuthorizedPrincipals
        : ZIO[Any, Nothing, List[AuthorizedPrincipalIdentifier]] =
      ZIO.succeed(authorizedPrincipals)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
    def getManageAccessRole: ZIO[Any, Nothing, String] =
      ZIO.succeed(manageAccessRole)
    def getName: ZIO[Any, Nothing, SubscriptionTargetName] = ZIO.succeed(name)
    def getProvider: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("provider", provider)
    def getSubscriptionTargetConfig: ZIO[Any, Nothing, List[
      zio.aws.datazone.model.SubscriptionTargetForm.ReadOnly
    ]] = ZIO.succeed(subscriptionTargetConfig)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetRequest
  ) extends zio.aws.datazone.model.CreateSubscriptionTargetRequest.ReadOnly {
    override val applicableAssetTypes: List[TypeName] = impl
      .applicableAssetTypes()
      .asScala
      .map { item =>
        zio.aws.datazone.model.primitives.TypeName(item)
      }
      .toList
    override val authorizedPrincipals: List[AuthorizedPrincipalIdentifier] =
      impl
        .authorizedPrincipals()
        .asScala
        .map { item =>
          zio.aws.datazone.model.primitives.AuthorizedPrincipalIdentifier(item)
        }
        .toList
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val environmentIdentifier: EnvironmentId =
      zio.aws.datazone.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
    override val manageAccessRole: String = impl.manageAccessRole(): String
    override val name: SubscriptionTargetName =
      zio.aws.datazone.model.primitives.SubscriptionTargetName(impl.name())
    override val provider: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.provider())
      .map(value => value: String)
    override val subscriptionTargetConfig
        : List[zio.aws.datazone.model.SubscriptionTargetForm.ReadOnly] = impl
      .subscriptionTargetConfig()
      .asScala
      .map { item =>
        zio.aws.datazone.model.SubscriptionTargetForm.wrap(item)
      }
      .toList
    override val `type`: String = impl.`type`(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateSubscriptionTargetRequest
  ): zio.aws.datazone.model.CreateSubscriptionTargetRequest.ReadOnly =
    new Wrapper(impl)
}
