package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  ProjectId,
  DomainId,
  Revision,
  Description,
  FormTypeName
}
import scala.jdk.CollectionConverters.*
final case class CreateFormTypeResponse(
    description: Optional[Description] = Optional.Absent,
    domainId: DomainId,
    name: FormTypeName,
    originDomainId: Optional[DomainId] = Optional.Absent,
    originProjectId: Optional[ProjectId] = Optional.Absent,
    owningProjectId: Optional[ProjectId] = Optional.Absent,
    revision: Revision
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateFormTypeResponse = {
    import CreateFormTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateFormTypeResponse
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .name(FormTypeName.unwrap(name): java.lang.String)
      .optionallyWith(
        originDomainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.originDomainId)
      .optionallyWith(
        originProjectId.map(value => ProjectId.unwrap(value): java.lang.String)
      )(_.originProjectId)
      .optionallyWith(
        owningProjectId.map(value => ProjectId.unwrap(value): java.lang.String)
      )(_.owningProjectId)
      .revision(Revision.unwrap(revision): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateFormTypeResponse.ReadOnly =
    zio.aws.datazone.model.CreateFormTypeResponse.wrap(buildAwsValue())
}
object CreateFormTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateFormTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateFormTypeResponse =
      zio.aws.datazone.model.CreateFormTypeResponse(
        description.map(value => value),
        domainId,
        name,
        originDomainId.map(value => value),
        originProjectId.map(value => value),
        owningProjectId.map(value => value),
        revision
      )
    def description: Optional[Description]
    def domainId: DomainId
    def name: FormTypeName
    def originDomainId: Optional[DomainId]
    def originProjectId: Optional[ProjectId]
    def owningProjectId: Optional[ProjectId]
    def revision: Revision
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getName: ZIO[Any, Nothing, FormTypeName] = ZIO.succeed(name)
    def getOriginDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("originDomainId", originDomainId)
    def getOriginProjectId: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("originProjectId", originProjectId)
    def getOwningProjectId: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("owningProjectId", owningProjectId)
    def getRevision: ZIO[Any, Nothing, Revision] = ZIO.succeed(revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateFormTypeResponse
  ) extends zio.aws.datazone.model.CreateFormTypeResponse.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val name: FormTypeName =
      zio.aws.datazone.model.primitives.FormTypeName(impl.name())
    override val originDomainId: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.originDomainId())
      .map(value => zio.aws.datazone.model.primitives.DomainId(value))
    override val originProjectId: Optional[ProjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.originProjectId())
      .map(value => zio.aws.datazone.model.primitives.ProjectId(value))
    override val owningProjectId: Optional[ProjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.owningProjectId())
      .map(value => zio.aws.datazone.model.primitives.ProjectId(value))
    override val revision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.revision())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateFormTypeResponse
  ): zio.aws.datazone.model.CreateFormTypeResponse.ReadOnly = new Wrapper(impl)
}
