package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  RoleArn,
  TagValue,
  DomainId,
  KmsKeyArn,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateDomainResponse(
    arn: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    domainExecutionRole: Optional[RoleArn] = Optional.Absent,
    id: DomainId,
    kmsKeyIdentifier: Optional[KmsKeyArn] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    portalUrl: Optional[String] = Optional.Absent,
    singleSignOn: Optional[zio.aws.datazone.model.SingleSignOn] =
      Optional.Absent,
    status: Optional[zio.aws.datazone.model.DomainStatus] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateDomainResponse = {
    import CreateDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateDomainResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        domainExecutionRole.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.domainExecutionRole)
      .id(DomainId.unwrap(id): java.lang.String)
      .optionallyWith(
        kmsKeyIdentifier.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyIdentifier)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(portalUrl.map(value => value: java.lang.String))(
        _.portalUrl
      )
      .optionallyWith(singleSignOn.map(value => value.buildAwsValue()))(
        _.singleSignOn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateDomainResponse.ReadOnly =
    zio.aws.datazone.model.CreateDomainResponse.wrap(buildAwsValue())
}
object CreateDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateDomainResponse =
      zio.aws.datazone.model.CreateDomainResponse(
        arn.map(value => value),
        description.map(value => value),
        domainExecutionRole.map(value => value),
        id,
        kmsKeyIdentifier.map(value => value),
        name.map(value => value),
        portalUrl.map(value => value),
        singleSignOn.map(value => value.asEditable),
        status.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[String]
    def description: Optional[String]
    def domainExecutionRole: Optional[RoleArn]
    def id: DomainId
    def kmsKeyIdentifier: Optional[KmsKeyArn]
    def name: Optional[String]
    def portalUrl: Optional[String]
    def singleSignOn: Optional[zio.aws.datazone.model.SingleSignOn.ReadOnly]
    def status: Optional[zio.aws.datazone.model.DomainStatus]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDomainExecutionRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("domainExecutionRole", domainExecutionRole)
    def getId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(id)
    def getKmsKeyIdentifier: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyIdentifier", kmsKeyIdentifier)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getPortalUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("portalUrl", portalUrl)
    def getSingleSignOn
        : ZIO[Any, AwsError, zio.aws.datazone.model.SingleSignOn.ReadOnly] =
      AwsError.unwrapOptionField("singleSignOn", singleSignOn)
    def getStatus: ZIO[Any, AwsError, zio.aws.datazone.model.DomainStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateDomainResponse
  ) extends zio.aws.datazone.model.CreateDomainResponse.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val domainExecutionRole: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.domainExecutionRole())
      .map(value => zio.aws.datazone.model.primitives.RoleArn(value))
    override val id: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.id())
    override val kmsKeyIdentifier: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyIdentifier())
      .map(value => zio.aws.datazone.model.primitives.KmsKeyArn(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val portalUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.portalUrl())
      .map(value => value: String)
    override val singleSignOn
        : Optional[zio.aws.datazone.model.SingleSignOn.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.singleSignOn())
        .map(value => zio.aws.datazone.model.SingleSignOn.wrap(value))
    override val status: Optional[zio.aws.datazone.model.DomainStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.DomainStatus.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.datazone.model.primitives
              .TagKey(key) -> zio.aws.datazone.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateDomainResponse
  ): zio.aws.datazone.model.CreateDomainResponse.ReadOnly = new Wrapper(impl)
}
