package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  UpdatedBy,
  ProjectId,
  CreatedAt,
  DomainId,
  Revision,
  FormName,
  Description,
  CreatedBy,
  TypeName,
  UpdatedAt
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AssetTypeItem(
    createdAt: Optional[CreatedAt] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    domainId: DomainId,
    formsOutput: Map[FormName, zio.aws.datazone.model.FormEntryOutput],
    name: TypeName,
    originDomainId: Optional[DomainId] = Optional.Absent,
    originProjectId: Optional[ProjectId] = Optional.Absent,
    owningProjectId: ProjectId,
    revision: Revision,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.AssetTypeItem = {
    import AssetTypeItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.AssetTypeItem
      .builder()
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .formsOutput(
        formsOutput
          .map({ case (key, value) =>
            (FormName.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .name(TypeName.unwrap(name): java.lang.String)
      .optionallyWith(
        originDomainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.originDomainId)
      .optionallyWith(
        originProjectId.map(value => ProjectId.unwrap(value): java.lang.String)
      )(_.originProjectId)
      .owningProjectId(ProjectId.unwrap(owningProjectId): java.lang.String)
      .revision(Revision.unwrap(revision): java.lang.String)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.AssetTypeItem.ReadOnly =
    zio.aws.datazone.model.AssetTypeItem.wrap(buildAwsValue())
}
object AssetTypeItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.AssetTypeItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.AssetTypeItem =
      zio.aws.datazone.model.AssetTypeItem(
        createdAt.map(value => value),
        createdBy.map(value => value),
        description.map(value => value),
        domainId,
        formsOutput.map({ case (key, value) =>
          key -> value.asEditable
        }),
        name,
        originDomainId.map(value => value),
        originProjectId.map(value => value),
        owningProjectId,
        revision,
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def createdAt: Optional[CreatedAt]
    def createdBy: Optional[CreatedBy]
    def description: Optional[Description]
    def domainId: DomainId
    def formsOutput
        : Map[FormName, zio.aws.datazone.model.FormEntryOutput.ReadOnly]
    def name: TypeName
    def originDomainId: Optional[DomainId]
    def originProjectId: Optional[ProjectId]
    def owningProjectId: ProjectId
    def revision: Revision
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getFormsOutput: ZIO[Any, Nothing, Map[
      FormName,
      zio.aws.datazone.model.FormEntryOutput.ReadOnly
    ]] = ZIO.succeed(formsOutput)
    def getName: ZIO[Any, Nothing, TypeName] = ZIO.succeed(name)
    def getOriginDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("originDomainId", originDomainId)
    def getOriginProjectId: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("originProjectId", originProjectId)
    def getOwningProjectId: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(owningProjectId)
    def getRevision: ZIO[Any, Nothing, Revision] = ZIO.succeed(revision)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.AssetTypeItem
  ) extends zio.aws.datazone.model.AssetTypeItem.ReadOnly {
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.datazone.model.primitives.CreatedAt(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.datazone.model.primitives.CreatedBy(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val formsOutput
        : Map[FormName, zio.aws.datazone.model.FormEntryOutput.ReadOnly] = impl
      .formsOutput()
      .asScala
      .map({ case (key, value) =>
        zio.aws.datazone.model.primitives
          .FormName(key) -> zio.aws.datazone.model.FormEntryOutput.wrap(value)
      })
      .toMap
    override val name: TypeName =
      zio.aws.datazone.model.primitives.TypeName(impl.name())
    override val originDomainId: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.originDomainId())
      .map(value => zio.aws.datazone.model.primitives.DomainId(value))
    override val originProjectId: Optional[ProjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.originProjectId())
      .map(value => zio.aws.datazone.model.primitives.ProjectId(value))
    override val owningProjectId: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.owningProjectId())
    override val revision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.revision())
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.datazone.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.datazone.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.AssetTypeItem
  ): zio.aws.datazone.model.AssetTypeItem.ReadOnly = new Wrapper(impl)
}
