package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.ListingId
import scala.jdk.CollectionConverters.*
final case class AssetListingDetails(
    listingId: ListingId,
    listingStatus: zio.aws.datazone.model.ListingStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.AssetListingDetails = {
    import AssetListingDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.AssetListingDetails
      .builder()
      .listingId(ListingId.unwrap(listingId): java.lang.String)
      .listingStatus(listingStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.AssetListingDetails.ReadOnly =
    zio.aws.datazone.model.AssetListingDetails.wrap(buildAwsValue())
}
object AssetListingDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.AssetListingDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.AssetListingDetails =
      zio.aws.datazone.model.AssetListingDetails(listingId, listingStatus)
    def listingId: ListingId
    def listingStatus: zio.aws.datazone.model.ListingStatus
    def getListingId: ZIO[Any, Nothing, ListingId] = ZIO.succeed(listingId)
    def getListingStatus
        : ZIO[Any, Nothing, zio.aws.datazone.model.ListingStatus] =
      ZIO.succeed(listingStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.AssetListingDetails
  ) extends zio.aws.datazone.model.AssetListingDetails.ReadOnly {
    override val listingId: ListingId =
      zio.aws.datazone.model.primitives.ListingId(impl.listingId())
    override val listingStatus: zio.aws.datazone.model.ListingStatus =
      zio.aws.datazone.model.ListingStatus.wrap(impl.listingStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.AssetListingDetails
  ): zio.aws.datazone.model.AssetListingDetails.ReadOnly = new Wrapper(impl)
}
