package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.ListingId
import scala.jdk.CollectionConverters._
final case class SubscribedListingInput(identifier: ListingId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SubscribedListingInput = {
    import SubscribedListingInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SubscribedListingInput
      .builder()
      .identifier(ListingId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SubscribedListingInput.ReadOnly =
    zio.aws.datazone.model.SubscribedListingInput.wrap(buildAwsValue())
}
object SubscribedListingInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SubscribedListingInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SubscribedListingInput =
      zio.aws.datazone.model.SubscribedListingInput(identifier)
    def identifier: ListingId
    def getIdentifier: ZIO[Any, Nothing, ListingId] = ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedListingInput
  ) extends zio.aws.datazone.model.SubscribedListingInput.ReadOnly {
    override val identifier: ListingId =
      zio.aws.datazone.model.primitives.ListingId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedListingInput
  ): zio.aws.datazone.model.SubscribedListingInput.ReadOnly = new Wrapper(impl)
}
