package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{Timestamp, Revision, AssetId}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SubscribedAsset(
    assetId: AssetId,
    assetRevision: Revision,
    failureCause: Optional[zio.aws.datazone.model.FailureCause] =
      Optional.Absent,
    failureTimestamp: Optional[Timestamp] = Optional.Absent,
    grantedTimestamp: Optional[Timestamp] = Optional.Absent,
    status: zio.aws.datazone.model.SubscriptionGrantStatus,
    targetName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SubscribedAsset = {
    import SubscribedAsset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SubscribedAsset
      .builder()
      .assetId(AssetId.unwrap(assetId): java.lang.String)
      .assetRevision(Revision.unwrap(assetRevision): java.lang.String)
      .optionallyWith(failureCause.map(value => value.buildAwsValue()))(
        _.failureCause
      )
      .optionallyWith(
        failureTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.failureTimestamp)
      .optionallyWith(
        grantedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.grantedTimestamp)
      .status(status.unwrap)
      .optionallyWith(targetName.map(value => value: java.lang.String))(
        _.targetName
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SubscribedAsset.ReadOnly =
    zio.aws.datazone.model.SubscribedAsset.wrap(buildAwsValue())
}
object SubscribedAsset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SubscribedAsset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SubscribedAsset =
      zio.aws.datazone.model.SubscribedAsset(
        assetId,
        assetRevision,
        failureCause.map(value => value.asEditable),
        failureTimestamp.map(value => value),
        grantedTimestamp.map(value => value),
        status,
        targetName.map(value => value)
      )
    def assetId: AssetId
    def assetRevision: Revision
    def failureCause: Optional[zio.aws.datazone.model.FailureCause.ReadOnly]
    def failureTimestamp: Optional[Timestamp]
    def grantedTimestamp: Optional[Timestamp]
    def status: zio.aws.datazone.model.SubscriptionGrantStatus
    def targetName: Optional[String]
    def getAssetId: ZIO[Any, Nothing, AssetId] = ZIO.succeed(assetId)
    def getAssetRevision: ZIO[Any, Nothing, Revision] =
      ZIO.succeed(assetRevision)
    def getFailureCause
        : ZIO[Any, AwsError, zio.aws.datazone.model.FailureCause.ReadOnly] =
      AwsError.unwrapOptionField("failureCause", failureCause)
    def getFailureTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("failureTimestamp", failureTimestamp)
    def getGrantedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("grantedTimestamp", grantedTimestamp)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.datazone.model.SubscriptionGrantStatus] =
      ZIO.succeed(status)
    def getTargetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetName", targetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedAsset
  ) extends zio.aws.datazone.model.SubscribedAsset.ReadOnly {
    override val assetId: AssetId =
      zio.aws.datazone.model.primitives.AssetId(impl.assetId())
    override val assetRevision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.assetRevision())
    override val failureCause
        : Optional[zio.aws.datazone.model.FailureCause.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureCause())
        .map(value => zio.aws.datazone.model.FailureCause.wrap(value))
    override val failureTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.failureTimestamp())
      .map(value => zio.aws.datazone.model.primitives.Timestamp(value))
    override val grantedTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.grantedTimestamp())
      .map(value => zio.aws.datazone.model.primitives.Timestamp(value))
    override val status: zio.aws.datazone.model.SubscriptionGrantStatus =
      zio.aws.datazone.model.SubscriptionGrantStatus.wrap(impl.status())
    override val targetName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedAsset
  ): zio.aws.datazone.model.SubscribedAsset.ReadOnly = new Wrapper(impl)
}
