package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.Attribute
import scala.jdk.CollectionConverters._
final case class SearchInItem(attribute: Attribute) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SearchInItem = {
    import SearchInItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SearchInItem
      .builder()
      .attribute(Attribute.unwrap(attribute): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SearchInItem.ReadOnly =
    zio.aws.datazone.model.SearchInItem.wrap(buildAwsValue())
}
object SearchInItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SearchInItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SearchInItem =
      zio.aws.datazone.model.SearchInItem(attribute)
    def attribute: Attribute
    def getAttribute: ZIO[Any, Nothing, Attribute] = ZIO.succeed(attribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SearchInItem
  ) extends zio.aws.datazone.model.SearchInItem.ReadOnly {
    override val attribute: Attribute =
      zio.aws.datazone.model.primitives.Attribute(impl.attribute())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SearchInItem
  ): zio.aws.datazone.model.SearchInItem.ReadOnly = new Wrapper(impl)
}
