package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.RedshiftRunConfigurationInputDataAccessRoleString
import scala.jdk.CollectionConverters._
final case class RedshiftRunConfigurationInput(
    dataAccessRole: Optional[
      RedshiftRunConfigurationInputDataAccessRoleString
    ] = Optional.Absent,
    redshiftCredentialConfiguration: zio.aws.datazone.model.RedshiftCredentialConfiguration,
    redshiftStorage: zio.aws.datazone.model.RedshiftStorage,
    relationalFilterConfigurations: Iterable[
      zio.aws.datazone.model.RelationalFilterConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RedshiftRunConfigurationInput = {
    import RedshiftRunConfigurationInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RedshiftRunConfigurationInput
      .builder()
      .optionallyWith(
        dataAccessRole.map(value =>
          RedshiftRunConfigurationInputDataAccessRoleString.unwrap(
            value
          ): java.lang.String
        )
      )(_.dataAccessRole)
      .redshiftCredentialConfiguration(
        redshiftCredentialConfiguration.buildAwsValue()
      )
      .redshiftStorage(redshiftStorage.buildAwsValue())
      .relationalFilterConfigurations(relationalFilterConfigurations.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.RedshiftRunConfigurationInput.ReadOnly =
    zio.aws.datazone.model.RedshiftRunConfigurationInput.wrap(buildAwsValue())
}
object RedshiftRunConfigurationInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RedshiftRunConfigurationInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RedshiftRunConfigurationInput =
      zio.aws.datazone.model.RedshiftRunConfigurationInput(
        dataAccessRole.map(value => value),
        redshiftCredentialConfiguration.asEditable,
        redshiftStorage.asEditable,
        relationalFilterConfigurations.map { item =>
          item.asEditable
        }
      )
    def dataAccessRole
        : Optional[RedshiftRunConfigurationInputDataAccessRoleString]
    def redshiftCredentialConfiguration
        : zio.aws.datazone.model.RedshiftCredentialConfiguration.ReadOnly
    def redshiftStorage: zio.aws.datazone.model.RedshiftStorage.ReadOnly
    def relationalFilterConfigurations
        : List[zio.aws.datazone.model.RelationalFilterConfiguration.ReadOnly]
    def getDataAccessRole: ZIO[
      Any,
      AwsError,
      RedshiftRunConfigurationInputDataAccessRoleString
    ] = AwsError.unwrapOptionField("dataAccessRole", dataAccessRole)
    def getRedshiftCredentialConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.datazone.model.RedshiftCredentialConfiguration.ReadOnly
    ] = ZIO.succeed(redshiftCredentialConfiguration)
    def getRedshiftStorage
        : ZIO[Any, Nothing, zio.aws.datazone.model.RedshiftStorage.ReadOnly] =
      ZIO.succeed(redshiftStorage)
    def getRelationalFilterConfigurations: ZIO[Any, Nothing, List[
      zio.aws.datazone.model.RelationalFilterConfiguration.ReadOnly
    ]] = ZIO.succeed(relationalFilterConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RedshiftRunConfigurationInput
  ) extends zio.aws.datazone.model.RedshiftRunConfigurationInput.ReadOnly {
    override val dataAccessRole
        : Optional[RedshiftRunConfigurationInputDataAccessRoleString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataAccessRole())
        .map(value =>
          zio.aws.datazone.model.primitives
            .RedshiftRunConfigurationInputDataAccessRoleString(value)
        )
    override val redshiftCredentialConfiguration
        : zio.aws.datazone.model.RedshiftCredentialConfiguration.ReadOnly =
      zio.aws.datazone.model.RedshiftCredentialConfiguration
        .wrap(impl.redshiftCredentialConfiguration())
    override val redshiftStorage
        : zio.aws.datazone.model.RedshiftStorage.ReadOnly =
      zio.aws.datazone.model.RedshiftStorage.wrap(impl.redshiftStorage())
    override val relationalFilterConfigurations
        : List[zio.aws.datazone.model.RelationalFilterConfiguration.ReadOnly] =
      impl
        .relationalFilterConfigurations()
        .asScala
        .map { item =>
          zio.aws.datazone.model.RelationalFilterConfiguration.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RedshiftRunConfigurationInput
  ): zio.aws.datazone.model.RedshiftRunConfigurationInput.ReadOnly =
    new Wrapper(impl)
}
