package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListingItem(
    assetListing: Optional[zio.aws.datazone.model.AssetListing] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListingItem = {
    import ListingItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListingItem
      .builder()
      .optionallyWith(assetListing.map(value => value.buildAwsValue()))(
        _.assetListing
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ListingItem.ReadOnly =
    zio.aws.datazone.model.ListingItem.wrap(buildAwsValue())
}
object ListingItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListingItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListingItem = zio.aws.datazone.model
      .ListingItem(assetListing.map(value => value.asEditable))
    def assetListing: Optional[zio.aws.datazone.model.AssetListing.ReadOnly]
    def getAssetListing
        : ZIO[Any, AwsError, zio.aws.datazone.model.AssetListing.ReadOnly] =
      AwsError.unwrapOptionField("assetListing", assetListing)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListingItem
  ) extends zio.aws.datazone.model.ListingItem.ReadOnly {
    override val assetListing
        : Optional[zio.aws.datazone.model.AssetListing.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetListing())
        .map(value => zio.aws.datazone.model.AssetListing.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListingItem
  ): zio.aws.datazone.model.ListingItem.ReadOnly = new Wrapper(impl)
}
