package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  PaginationToken,
  MaxResults,
  DomainId,
  Timestamp
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListNotificationsRequest(
    afterTimestamp: Optional[Timestamp] = Optional.Absent,
    beforeTimestamp: Optional[Timestamp] = Optional.Absent,
    domainIdentifier: DomainId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    subjects: Optional[Iterable[String]] = Optional.Absent,
    taskStatus: Optional[zio.aws.datazone.model.TaskStatus] = Optional.Absent,
    `type`: zio.aws.datazone.model.NotificationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListNotificationsRequest = {
    import ListNotificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListNotificationsRequest
      .builder()
      .optionallyWith(
        afterTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.afterTimestamp)
      .optionallyWith(
        beforeTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.beforeTimestamp)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        subjects.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subjects)
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ListNotificationsRequest.ReadOnly =
    zio.aws.datazone.model.ListNotificationsRequest.wrap(buildAwsValue())
}
object ListNotificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListNotificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListNotificationsRequest =
      zio.aws.datazone.model.ListNotificationsRequest(
        afterTimestamp.map(value => value),
        beforeTimestamp.map(value => value),
        domainIdentifier,
        maxResults.map(value => value),
        nextToken.map(value => value),
        subjects.map(value => value),
        taskStatus.map(value => value),
        `type`
      )
    def afterTimestamp: Optional[Timestamp]
    def beforeTimestamp: Optional[Timestamp]
    def domainIdentifier: DomainId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def subjects: Optional[List[String]]
    def taskStatus: Optional[zio.aws.datazone.model.TaskStatus]
    def `type`: zio.aws.datazone.model.NotificationType
    def getAfterTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("afterTimestamp", afterTimestamp)
    def getBeforeTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("beforeTimestamp", beforeTimestamp)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSubjects: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subjects", subjects)
    def getTaskStatus: ZIO[Any, AwsError, zio.aws.datazone.model.TaskStatus] =
      AwsError.unwrapOptionField("taskStatus", taskStatus)
    def getType: ZIO[Any, Nothing, zio.aws.datazone.model.NotificationType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListNotificationsRequest
  ) extends zio.aws.datazone.model.ListNotificationsRequest.ReadOnly {
    override val afterTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.afterTimestamp())
      .map(value => zio.aws.datazone.model.primitives.Timestamp(value))
    override val beforeTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.beforeTimestamp())
      .map(value => zio.aws.datazone.model.primitives.Timestamp(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val subjects: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subjects())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val taskStatus: Optional[zio.aws.datazone.model.TaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStatus())
        .map(value => zio.aws.datazone.model.TaskStatus.wrap(value))
    override val `type`: zio.aws.datazone.model.NotificationType =
      zio.aws.datazone.model.NotificationType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListNotificationsRequest
  ): zio.aws.datazone.model.ListNotificationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
