package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{Revision, AssetIdentifier, DomainId}
import scala.jdk.CollectionConverters._
final case class GetAssetRequest(
    domainIdentifier: DomainId,
    identifier: AssetIdentifier,
    revision: Optional[Revision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetAssetRequest = {
    import GetAssetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetAssetRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(AssetIdentifier.unwrap(identifier): java.lang.String)
      .optionallyWith(
        revision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.revision)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetAssetRequest.ReadOnly =
    zio.aws.datazone.model.GetAssetRequest.wrap(buildAwsValue())
}
object GetAssetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetAssetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetAssetRequest =
      zio.aws.datazone.model.GetAssetRequest(
        domainIdentifier,
        identifier,
        revision.map(value => value)
      )
    def domainIdentifier: DomainId
    def identifier: AssetIdentifier
    def revision: Optional[Revision]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, AssetIdentifier] =
      ZIO.succeed(identifier)
    def getRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("revision", revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetAssetRequest
  ) extends zio.aws.datazone.model.GetAssetRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: AssetIdentifier =
      zio.aws.datazone.model.primitives.AssetIdentifier(impl.identifier())
    override val revision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetAssetRequest
  ): zio.aws.datazone.model.GetAssetRequest.ReadOnly = new Wrapper(impl)
}
