package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{EnvironmentId, DomainId}
import scala.jdk.CollectionConverters._
final case class DeleteEnvironmentRequest(
    domainIdentifier: DomainId,
    identifier: EnvironmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DeleteEnvironmentRequest = {
    import DeleteEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DeleteEnvironmentRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(EnvironmentId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DeleteEnvironmentRequest.ReadOnly =
    zio.aws.datazone.model.DeleteEnvironmentRequest.wrap(buildAwsValue())
}
object DeleteEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DeleteEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DeleteEnvironmentRequest =
      zio.aws.datazone.model
        .DeleteEnvironmentRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: EnvironmentId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DeleteEnvironmentRequest
  ) extends zio.aws.datazone.model.DeleteEnvironmentRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: EnvironmentId =
      zio.aws.datazone.model.primitives.EnvironmentId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DeleteEnvironmentRequest
  ): zio.aws.datazone.model.DeleteEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
